var jeuEurope = jeuEurope || {};

(function(jeuEurope){

	jeuEurope.EndWindow = EndWindow;

	//héritage
	EndWindow.prototype = Object.create(Container.prototype);

	function EndWindow(playersScore,callbackExit)
	{
		//constructeur parent
		Container.call(this);

		//bloque les event "derriere" la fenetre
		this.interactive = true;
		this.callbackExit = callbackExit;
		this.playersScore = playersScore;
		this.playersLine = [];

		//propriétés
		this.btnExit = undefined;
		this.window = undefined;

		this.window = new Sprite(getTexture("endWindow","background"));
		this.addChild(this.window);

		this.pictoPrint = new Sprite(getTexture("endWindow","btnPrint"));
		this.pictoPrint.anchor.set(0.5,0.5);
		this.pictoPrint.position.set(1215,120);
		this.addChild(this.pictoPrint);

		this.btnClose = new jeuEurope.Button(
			getTexture("infoWindow","btnExitUp"),
			getTexture("infoWindow","btnExitDown"),
			getTexture("infoWindow","btnExitHover"),
			this.onPressExit.bind(this));

		this.btnClose.anchor.set(0.5,0.5);
		this.btnClose.position.set(
			jeuEurope.appParam.stageWidth - 30,
			30);
		this.addChild(this.btnClose);

		this.playersScore.sort(function(a,b){
			if(a.score.total < b.score.total) return 1;
			if(a.score.total > b.score.total) return -1;
			if(a.score.reachedEnd && !b.score.reachedEnd) return -1;
			if(!a.score.reachedEnd && b.score.reachedEnd) return 1;
			return 0;
		});

		var startHeight = 230;
		var spaceLine = 80;

		for (var i = 0; i < this.playersScore.length; i++) {
			var pScore = this.playersScore[i];
			pScore.rank = i+1;

			var line = this.createLine(pScore);
			this.playersLine.push(line);
			this.addChild(line);

			line.x = 65;
			line.y = startHeight + spaceLine * i;
		};

		//-------- titre sections

		var type = 
		[
			"elec",
			"div",
			"peine",
			"egal",
			"jus",
			"lib"
		];

		var startX = 340;
		var spaceX = 120;

		for (var i = 0; i < type.length; i++) {
			var t = type[i];

			var text = new Text(
				getText("home",t),
				{
					font:"16px monstro",
					fill:0x0d437f,
					align:"center",
					stroke:0xffffff,
					strokeThickness:1,
					wordWrap:true,
					wordWrapWidth:110
				});

			this.addChild(text);
			text.anchor.set(0.5,0.5);
			text.position.set(startX + spaceX * i, 120);
		}

		var total = new Text(
			getText("endWindow","total"),
			{
				font:"16px monstro",
				fill:0x0d437f,
				align:"center",
				stroke:0xffffff,
				strokeThickness:1,
				wordWrap:true,
				wordWrapWidth:110
			});

		this.addChild(total);
		total.anchor.set(0.5,0.5);
		total.position.set(startX + spaceX * i, 120);

		/*i++;

		var endOrder = new Text(
			getText("endWindow","endOrder"),
			{
				font:"16px monstro",
				fill:0x0d437f,
				align:"center",
				stroke:0xffffff,
				strokeThickness:1,
				wordWrap:true,
				wordWrapWidth:110
			});

		this.addChild(endOrder);
		endOrder.anchor.set(0.5,0.5);
		endOrder.position.set(startX + spaceX * i, 120);*/

		//console.log(this.playersLine);

		createjs.Sound.play("hiphop");

		this.escape = new Keyboard(27);
		this.escape.press = this.onPressExit.bind(this);
		this.space = new Keyboard(32);
		this.space.press = this.onPressExit.bind(this);
	}	

	EndWindow.prototype.createLine = function(data)
	{
		var line = new Container();
		line.data = data;

		line.picto = new Sprite(getTexture("endWindow","team"+data.id));
		line.picto.anchor.set(0,0.5);
		line.addChild(line.picto);

		line.name = new Text(data.name,
			{
				font:"28px monstro",
				fill:0x183f87,
				align:"left"
			});

		line.name.anchor.set(0,0.5);
		line.name.position.set(75,0);
		line.addChild(line.name);

		var type = 
		[
			"elec",
			"div",
			"peine",
			"egal",
			"jus",
			"lib"
		];

		var startX = 275;
		var spaceX = 120;

		for (var i = 0; i < type.length; i++) {
			var t = type[i];

			line[t] = new Text(data.score[t],
				{
					font:"40px robotor",
					fill:0x183f87,
					align:"left",
					dropShadow:true,
					dropShadowColor:0xffffff,
					dropShadowDistance:2
				});

			line[t].anchor.set(0.5,0.5);
			line[t].position.set(startX + i * spaceX,0);
			line.addChild(line[t]);
		};

		var starPos = startX + i * spaceX;

		line.total = new Sprite(getTexture("gameUi",data.rank == 1 ? "starOn" : "starOff"));
		line.total.anchor.set(0.5,0.5);
		line.total.position.set(starPos,0);
		line.addChild(line.total);

		line.totalText = new Text(
			data.score.total,
			{
				font:"26px robotor",
				fill:0xffffff,
				align:"center"
			});
		line.totalText.anchor.set(0.5,0.5);
		line.total.addChild(line.totalText);

		line.btnPrint = new jeuEurope.Button(
			getTexture("endWindow","btnDiplomeUp"),
			getTexture("endWindow","btnDiplomeDown"),
			getTexture("endWindow","btnDiplomeHover"),
			function(){this.onPrintPlayerScore(data);}.bind(this));
		line.btnPrint.anchor.set(0.5,0.5);
		line.btnPrint.position.set(1150,0);
		line.addChild(line.btnPrint);

		return line;
	}

	EndWindow.prototype.onPrintPlayerScore = function(data)
	{
		createjs.Sound.play("bouton");

		window.open("print.html?name="+data.name+"&school="+data.school+"&lang="+getLanguage());
	}

	EndWindow.prototype.update = function()
	{
		
	}

	EndWindow.prototype.onPressExit = function()
	{
		this.escape.remove();
		this.space.remove();
		
		createjs.Sound.play("bouton");
		createjs.Sound.stop("hiphop");
		this.callbackExit();
	}


}(jeuEurope));