var jeuEurope = jeuEurope || {};

(function(jeuEurope){

	jeuEurope.TextLoader = TextLoader;

	function TextLoader()
	{
		this.loadedTexts = {};

		this.numberToLoad = 8;
		this.numberLoaded = 0;

		this.callEnd = undefined;
	}

	TextLoader.prototype.getText = function(group,id)
	{
		
		if(this.loadedTexts[getLanguage()])
		{
			if(this.loadedTexts[getLanguage()].common[group])
			{
				if(this.loadedTexts[getLanguage()].common[group][id])
				{
					return this.loadedTexts[getLanguage()].common[group][id];
				}
				else
					console.log("l'id "+id+" n'existe pas");
			}
			else
				console.log("le groupe "+group+" n'existe pas");
		}
		else
			console.log("pas de données pour la langue actuelle");
	}

	TextLoader.prototype.getContent = function(group)
	{
		if(this.loadedTexts[getLanguage()])
			if(this.loadedTexts[getLanguage()][group])
				return this.loadedTexts[getLanguage()][group];
	}

	TextLoader.prototype.loadXML = function(callEnd)
	{
		this.callEnd = callEnd;

		//French
		$.get("./assets/texts/contentFr.xml", {}, 
			function(xml){
				this.onContentXMLLoaded("fr",xml);
			}.bind(this)
		);
		$.get("./assets/texts/textFr.xml", {}, 
			function(xml){
				this.onTextXMLLoaded("fr",xml);
			}.bind(this)
		);

		//English
		$.get("./assets/texts/contentEn.xml", {}, 
			function(xml){
				this.onContentXMLLoaded("en",xml);
			}.bind(this)
		);
		$.get("./assets/texts/textEn.xml", {}, 
			function(xml){
				this.onTextXMLLoaded("en",xml);
			}.bind(this)
		);

		//Deutch
		$.get("./assets/texts/contentDe.xml", {}, 
			function(xml){
				this.onContentXMLLoaded("de",xml);
			}.bind(this)
		);
		$.get("./assets/texts/textDe.xml", {}, 
			function(xml){
				this.onTextXMLLoaded("de",xml);
			}.bind(this)
		);

//Grec
		$.get("./assets/texts/contentGr.xml", {}, 
			function(xml){
				this.onContentXMLLoaded("gr",xml);
			}.bind(this)
		);
		$.get("./assets/texts/textGr.xml", {}, 
			function(xml){
				this.onTextXMLLoaded("gr",xml);
			}.bind(this)
		);
	}

	TextLoader.prototype.onEndLoad = function()
	{
		this.numberLoaded++;

		if(this.numberLoaded >= 
			this.numberToLoad)
			this.callEnd();
	}

	TextLoader.prototype.onTextXMLLoaded = function(langue,xml)
	{
		var childrenKey = xml.children ? "children" : "childNodes";

		if(!this.loadedTexts[langue])
		 	this.loadedTexts[langue] = {};

		var objectRoot = this.loadedTexts[langue];

		if(!objectRoot.common)
			objectRoot.common = {};

		var objectCommon = objectRoot.common;

		var root = xml[childrenKey][0];

		for (var i = 0; i < root[childrenKey].length; i++) {
			var group = root[childrenKey][i];

			if(!group.tagName)
				continue;

			objectCommon[group.tagName] = {};

			for (var j = 0; j < group[childrenKey].length; j++) {
				var text = group[childrenKey][j];

				objectCommon[group.tagName][text.tagName] = text.textContent;
			};
		}

		this.onEndLoad();
	}

	TextLoader.prototype.onContentXMLLoaded = function(langue,xml)
	{
		var childrenKey = xml.children ? "children" : "childNodes";
		var indexArticle = childrenKey == "children" ? 1 : 3;
		var indexTitre = childrenKey == "children" ? 0 : 1;

		if(!this.loadedTexts[langue])
		 	this.loadedTexts[langue] = {};

		var objectRoot = this.loadedTexts[langue];

		var root = xml[childrenKey][0];

		for (var i = 0; i < root[childrenKey].length; i++) {
			var section = root[childrenKey][i];

			if(!section.tagName)
				continue;

			objectRoot[section.tagName] = {
				quest:[],
				defi:[],
				ouv:[]
			};

			var uppedName = section.tagName.capitalize();

			var objectSection = objectRoot[section.tagName];

			for (var j = 0; j < section[childrenKey].length; j++) {
				var element = section[childrenKey][j];

				if(!element.tagName)
					continue;

				var type = element.tagName.split("_")[0];


				if(type == "quest")
				{
					var article = element[childrenKey][indexArticle];
					var quest = {};
					quest.type = uppedName;
					quest.titre = element[childrenKey][indexTitre].textContent;
					quest.intro = $(article).find("intro").text();
					quest.quest = $(article).find("quest").text();
					quest.repok = $(article).find("repok").text();
					quest.caseText = $(article).find("case").text();
					quest.expl = $(article).find("expl").text();
					quest.mode = "quest";
					quest.rep = [];

					if(quest.caseText.indexOf("1") != -1)
					{
						quest.caseEffect = 1;
					}
					else if(quest.caseText.indexOf("2") != -1)
					{
						quest.caseEffect = 2;
					}

					var rep = $(article).find("rep");

					for (var k = 0; k < rep.length; k++) {
						var dataRep = rep[k].textContent;
						quest.rep.push(dataRep);
					};

					if(quest.type == ""
						|| quest.titre == ""
						|| quest.quest == ""
						|| quest.repok == ""
						|| quest.caseText == ""
						|| quest.expl == ""
						|| quest.rep.length < 1)
					{
						console.log("erreur dans une question fermée");
						console.log(quest);
					}

					objectSection.quest.push(quest);
				}
				else if(type == "defi")
				{
					var article = element[childrenKey][indexArticle];
					var defi = {};
					defi.type = uppedName;
					defi.mode = "defi";
					defi.titre = element[childrenKey][indexTitre].textContent;
					defi.intro = $(article).find("intro").text();
					defi.quest = $(article).find("quest").text();
					defi.caseText = $(article).find("case").text();
					defi.expl = $(article).find("expl").text();

					if(defi.caseText.indexOf("1") != -1)
					{
						defi.caseEffect = 1;
					}
					else if(defi.caseText.indexOf("2") != -1)
					{
						defi.caseEffect = 2;
					}

					if(defi.type == ""
						|| defi.titre == ""
						|| defi.quest == ""
						|| defi.caseText == "")
					{
						console.log("erreur dans un défi");
						console.log(defi);
					}

					objectSection.defi.push(defi);
				}
				else if(type == "ouv")
				{
					var article = element[childrenKey][indexArticle];
					var ouv = {};
					ouv.type = uppedName;
					ouv.mode = "ouv";
					ouv.titre = element[childrenKey][indexTitre].textContent;
					ouv.intro = $(article).find("intro").text();
					ouv.quest = $(article).find("quest").text();
					ouv.expl = $(article).find("expl").text();
					ouv.caseText = $(article).find("case").text();

					if(ouv.caseText.indexOf("1") != -1)
					{
						ouv.caseEffect = 1;
					}
					else if(ouv.caseText.indexOf("2") != -1)
					{
						ouv.caseEffect = 2;
					}

					if(ouv.type == ""
						|| ouv.titre == ""
						|| ouv.quest == ""
						|| ouv.caseText == "")
					{
						console.log("erreur dans une question ouverte");
						console.log(ouv);
					}

					objectSection.ouv.push(ouv);
				}

			};
		};

		this.onEndLoad();
	}

	jeuEurope.textLoader = new TextLoader();

}(jeuEurope));