var jeuEurope = jeuEurope || {};

(function(jeuEurope){

	jeuEurope.Home = Home;

	//héritage
	Home.prototype = Object.create(Container.prototype);

	function Home()
	{
		//constructeur parent
		Container.call(this);

		//propriétés
		this.titre1 = undefined;
		this.titre2 = undefined;

		this.btnInfo = undefined;
		this.btnSettings = undefined;

		this.buttonPass = undefined;
		this.textPass = undefined;

		this.cards = [];
		this.bigTween = undefined;

		this.settingsWindow = undefined;
		this.infoWindow = undefined;


		//------- Titre -------

		//console.log("text is" + getText("home","titre1"));

		this.titre1 = new Text(
			getText("home","titre1"),
			{
				font:"161px monstro",
				fill:0xf1cb12,
				align:"center"
			});

		this.titre1.anchor.set(0.5,0.5);

		this.titre1.x = jeuEurope.appParam.stageWidth / 2;
		this.titre1.y = 100;

		this.titre2 = new Text(
			getText("home","titre2"),
			{
				font:"94px monstro",
				fill:0xffffff,
				align:"center"
			});
		
		this.titre2.anchor.set(0.5,0.5);

		this.titre2.x = jeuEurope.appParam.stageWidth / 2;
		this.titre2.y = 210;

		this.addChild(this.titre1);
		this.addChild(this.titre2);

		//------- Button Pass -------
		this.buttonPass = new jeuEurope.Button(
			getTexture("home","btnUp"),
			getTexture("home","btnDown"),
			getTexture("home","btnHover"),
			this.onPressPass.bind(this));

		this.textPass = new Text(
			getText("home","btnPass"),
			{
				font:"26px robotor",
				fill:0xffffff,
				stroke:0x409e01, 
				strokeThickness:3, 
				align:"center",
				wordWrap:true,
				wordWrapWidth:210
			});

		this.textPass.y = -3;
		this.textPass.anchor.set(0.5,0.5);

		this.buttonPass.anchor.set(0.5,0.5);

		this.buttonPass.x = jeuEurope.appParam.stageWidth / 2;
		this.buttonPass.y = jeuEurope.appParam.stageHeight - 50;

		this.buttonPass.addChild(this.textPass);
		this.addChild(this.buttonPass);

		//-------- Buttons -------
		//info
		this.btnInfo = new jeuEurope.Button(
			getTexture("home","btnInfoUp"),
			getTexture("home","btnInfoDown"),
			getTexture("home","btnInfoHover"),
			this.onPressInfo.bind(this));

		this.btnInfo.position.set(100,725);
		this.addChild(this.btnInfo);

		//settings
		this.btnSettings = new jeuEurope.Button(
			getTexture("home","btnSettingsUp"),
			getTexture("home","btnSettingsDown"),
			getTexture("home","btnSettingsHover"),
			this.onPressSettings.bind(this));

		this.btnSettings.position.set(15,725);
		this.addChild(this.btnSettings);

		//-------- Cartes --------

		var cartesId = 
		[
			"elec",
			"div",
			"peine",
			"egal",
			"jus",
			"lib"
		];

		for (var i = 0; i < cartesId.length; i++) {
			var id = cartesId[i];

			var card = {};
			card.id = id;

			var backCard = new Sprite(getTexture("home","backCard"));
			this.addChild(backCard);
			card.backCard = backCard;

			backCard.anchor.set(0.5,0.5);

			var backText1 = new Text(
				getText("home","titre1"),
				{
					font:"45px monstro",
					fill:0xf1cb12,
					align:"center",
					wordWrap:true,
					wordWrapWidth:140
				});

			backText1.anchor.set(0.5,1);
			backText1.position.set(0,60);

			backCard.addChild(backText1);
			card.backText1 = backText1;

			var backText2 = new Text(
				getText("home","titre2"),
				{
					font:"20px monstro",
					fill:0xffffff,
					align:"center",
					wordWrap:true,
					wordWrapWidth:140
				});

			backText2.anchor.set(0.5,0);
			backText2.position.set(0,75);

			backCard.addChild(backText2);
			card.backText2 = backText2;

			var frontCard = new Sprite(getTexture("home",id));
			this.addChild(frontCard);
			card.frontCard = frontCard;

			this.cards.push(card);

			frontCard.anchor.set(0.5,0.5);

			backCard.x = frontCard.x = 20 + frontCard.width/2 + 208 * i;
			backCard.y = frontCard.y = (i%2 == 0 ? 450 : 500);

			frontCard.scale.x = 0;

			var frontText = new Text(
				getText("home",id),
				{
					font:"24px monstro",
					fill:0x0d437f,
					align:"center",
					wordWrap:true,
					wordWrapWidth:170
				});

			if(frontText.width > 180)
			{
				var ratio = 180 / frontText.width;
				frontText.scale.set(ratio,ratio);
			}

			frontText.anchor.set(0.5,0);
			frontText.position.set(0,-150);

			frontCard.addChild(frontText);
			card.frontText = frontText;
		};

		//créé les tweens
		var tweenArray = [];
		for (var i = 0; i < this.cards.length; i++) {
			var c = this.cards[i];

			var tweenBack = new Tween(c.backCard, "scale.x", 0, 60, false);
			tweenBack.easing = Tween.inCubic;

			var tweenFront = new Tween(c.frontCard, "scale.x", 1, 60, false);
			tweenFront.easing = Tween.outCubic;

			var tweenTempo = new Tween(c, "tempo", 10, 10, false);

			tweenArray.push(tweenBack);
			tweenArray.push(tweenFront);
			tweenArray.push(tweenTempo);
		};

		this.bigTween = new ChainedTween(tweenArray);

		createjs.Sound.play("techno");
	}

	Home.prototype.onPressPass = function()
	{
		createjs.Sound.play("bouton");
		jeuEurope.current.openNewGame();
	}

	Home.prototype.onPressSettings = function()
	{
		createjs.Sound.play("bouton");
		this.settingsWindow = new jeuEurope.SettingsWindow(this.onCloseSettings.bind(this));
		this.addChild(this.settingsWindow);
	}

	Home.prototype.onCloseSettings = function()
	{
		this.removeChild(this.settingsWindow);
		this.settingsWindow = undefined;

		this.titre1.text = getText("home","titre1");
		this.titre2.text = getText("home","titre2");
		this.textPass.text = getText("home","btnPass");

		for (var i = 0; i < this.cards.length; i++) {
			var card  = this.cards[i];
			card.backText1.text = getText("home","titre1");
			card.backText2.text = getText("home","titre2");
			card.frontText.text = getText("home",card.id);

			card.frontText.scale.set(1,1);

			if(card.frontText.width > 180)
			{
				var ratio = 180 / card.frontText.width;
				card.frontText.scale.set(ratio,ratio);
			}
		}
	}

	Home.prototype.onPressInfo = function()
	{
		createjs.Sound.play("bouton");
		this.infoWindow = new jeuEurope.InfoWindow(this.onCloseInfo.bind(this));
		this.addChild(this.infoWindow);
	}

	Home.prototype.onCloseInfo = function()
	{
		this.removeChild(this.infoWindow);
		this.infoWindow = undefined;
	}

	Home.prototype.update = function()
	{
		
	}

	Home.prototype.close = function()
	{
		if(this.bigTween)
			this.bigTween.cancel();

		createjs.Sound.stop("techno");
	}

}(jeuEurope));