var jeuEurope = jeuEurope || {};

(function(jeuEurope){

	jeuEurope.BoardGame = BoardGame;

	//héritage
	BoardGame.prototype = Object.create(Container.prototype);

	function BoardGame(listPlayers)
	{
		//constructeur parent
		Container.call(this);

		//propriétés
		this.titre1 = undefined;
		this.titre2 = undefined;
		this.header = undefined;
		this.background = undefined;
		this.dice = undefined;
		this.listPlayers = listPlayers;
		this.stripStart = undefined;
		this.textStart = undefined;
		this.textureStart = undefined;
		this.stripEnd = undefined;
		this.textEnd = undefined;
		this.textureEnd = undefined;
		this.div = undefined;
		this.lib = undefined;
		this.elec = undefined;
		this.egal = undefined;
		this.jus = undefined;
		this.peine = undefined;
		this.playerTurn = undefined;
		this.pionsContainer;
		this.pions = [];
		this.boardGameData = jeuEurope.Datas.boardGameData;
		this.questWindow = undefined;
		this.waitDice = false;
		this.sections = [];
		this.questionDone = {};

		//construction
		this.background = new Sprite(getTexture("gameBoard","background"));
		this.addChild(this.background);

		this.header = new jeuEurope.GameUi(listPlayers);
		this.addChild(this.header);

		//texte depart
		this.textStart = new Text(
			getText("boardGame","start"),
			{
				font:"36px monstro",
				fill:0xf1cb12,
				align:"left"
			});

		this.textureStart = new RenderTexture(
			jeuEurope.appParam.renderer,
			this.textStart.width,
			this.textStart.height);
		this.textureStart.render(this.textStart);

		var ropeLength = this.textureStart.width / this.textStart.text.length;
		var points = [];
		var ret = this.arcCercle(0,0,this.textStart.width);
		for (var i = 0; i <= this.textStart.text.length; i++) {
			var index = (ret.length/this.textStart.text.length * i) | 0;
			points.push({x:i*ropeLength,y:ret[Math.min(index,ret.length-1)].y});
		}

		this.stripStart = new PIXI.mesh.Rope(this.textureStart,points);
		this.stripStart.x = 160;
		this.stripStart.y = 215;
		this.stripStart.rotation = deg2Rad(-65);

		this.addChild(this.stripStart);

		//texte arrivée
		this.textEnd = new Text(
			getText("boardGame","end"),
			{
				font:"36px monstro",
				fill:0xf1cb12,
				align:"center"
			});

		this.textureEnd = new RenderTexture(
			jeuEurope.appParam.renderer,
			this.textEnd.width,
			this.textEnd.height);
		this.textureEnd.render(this.textEnd);

		var ropeLength = this.textureEnd.width / this.textEnd.text.length;
		var points = [];
		var ret = this.arcCercle(0,0,this.textEnd.width);
		for (var i = 0; i <= this.textEnd.text.length; i++) {
			var index = (ret.length/this.textEnd.text.length * i) | 0;
			points.push({x:i*ropeLength,y:-ret[Math.min(index,ret.length-1)].y*1.2});
		}

		this.stripEnd = new PIXI.mesh.Rope(this.textureEnd,points);
		this.stripEnd.x = 500 - this.textureEnd.width * 1.1 / 2;
		this.stripEnd.y = 500;
		this.stripEnd.rotation = deg2Rad(20);

		this.addChild(this.stripEnd);


		//-----sections-----
		var data = this.boardGameData.sections;

		for (var i = 0; i < data.length; i++) {
			var d = data[i];

			this[d.id] = this.createSection(d);
			this.addChild(this[d.id]);
		};

		//-------- Text bottom

		this.titre1 = new Text(
			getText("home","titre1"),
			{
				font:"50px monstro",
				fill:0xf1cb12,
				align:"left"
			});
		this.titre1.x = 780;
		this.titre1.y = 700;
		this.addChild(this.titre1);

		this.titre2 = new Text(
			getText("home","titre2"),
			{
				font:"28px monstro",
				fill:0xffffff,
				align:"left"
			});
		this.titre2.x = 780;
		this.titre2.y = 750;
		this.addChild(this.titre2);

		//-------- Pions

		this.pionsContainer = new Container();
		this.addChild(this.pionsContainer);
		var anchors = {
			2:
			[
				{x:-25,y:0},
				{x:25,y:0}
			],
			3:
			[
				{x:0,y:20},
				{x:-25,y:-20},
				{x:25,y:-20}
			],
			4:
			[
				{x:-25,y:-25},
				{x:-25,y:25},
				{x:25,y:25},
				{x:25,y:-25}
			],
			5:
			[
				{x:0,y:30},
				{x:-35,y:0},
				{x:35,y:0},
				{x:-25,y:-30},
				{x:25,y:-30}
			],
			6:
			[
				{x:-25,y:30},
				{x:25,y:30},
				{x:-35,y:0},
				{x:35,y:0},
				{x:-25,y:-30},
				{x:25,y:-30}
			]
		}

		for (var i = 0; i < listPlayers.length; i++) {
			var d = listPlayers[i];
			var pion = this.createPion(d);

			var caseDep = this.boardGameData.cases[0];
			pion.position.set(caseDep.x,caseDep.y);

			var an = anchors[listPlayers.length][i];
			pion.pivot.set(an.x,an.y);

			this.pionsContainer.addChild(pion);
			this.pions.push(pion);
		};

		//-------- Dé

		this.dice = this.createDice();
		this.dice.position.set(1090,575);

		this.dice.on("mouseup",this.onPressDice.bind(this));
		this.dice.on("touchend",this.onPressDice.bind(this));

		this.addChild(this.dice);

		//------- Joker

		this.jokerWindow = new Sprite(getTexture("gameBoard","joker"));
		this.jokerWindow.anchor.set(0.5,0.5);
		this.jokerWindow.position.set(1090,575);
		this.jokerWindow.interactive = true;
		this.jokerWindow.visible = false;

		this.addChild(this.jokerWindow);

		this.jokerTitle = new Text(
			getText("boardGame","joker"),
			{
				font:"46px robotor",
				fill:0xffffff,
				align:"center",
				stroke:0x183f86,
				strokeThickness:6
			});
		this.jokerTitle.y = 15;
		this.jokerTitle.anchor.set(0.5,0.5);
		this.jokerWindow.addChild(this.jokerTitle);

		this.jokerText1 = new Text(
			getText("boardGame","joker1"),
			{
				font:"32px robotor",
				fill:0xf1cb12,
				align:"center"
			});
		this.jokerText1.y = 50;
		this.jokerText1.anchor.set(0.5,0.5);
		this.jokerWindow.addChild(this.jokerText1);

		this.jokerText2 = new Text(
			getText("boardGame","joker2"),
			{
				font:"22px robotor",
				fill:0xffffff,
				align:"center",
				wordWrap:true,
				wordWrapWidth:285
			});
		this.jokerText2.y = 85;
		this.jokerText2.anchor.set(0.5,0.5);
		this.jokerWindow.addChild(this.jokerText2);

		//------- QuestWindow

		this.beginTurn();
	}	

	BoardGame.prototype.createPion = function(data)
	{
		var pion = new Sprite(getTexture("gameUi","team"+data.id));

		pion.anchor.set(0.5,0.5);

		pion.data = data;

		pion.scores = {
			total:0,
			elec:0,
			div:0,
			lib:0,
			peine:0,
			egal:0,
			jus:0
		};

		pion.actualCase = 0;

		pion.tweening = false;

		pion.tweenOut = function()
		{
			var t = new Tween(this,"scale.x",1.0,50,true);	
			t.easing = Tween.inOutCubic;

			t = new Tween(this,"scale.y",1.0,50,true);	
			t.easing = Tween.inOutCubic;
			t.setOnComplete(this.tweenIn.bind(this));
		}

		pion.tweenIn = function()
		{
			if(this.tweening)
			{
				var t = new Tween(this,"scale.x",0.9,50,true);
				t.easing = Tween.inOutCubic;

				t = new Tween(this,"scale.y",0.9,50,true);
				t.easing = Tween.inOutCubic;
				t.setOnComplete(this.tweenOut.bind(this));
			}
		}

		pion.startTween = function()
		{
			this.tweening = true;
			this.tweenIn();
		}

		pion.stopTween = function()
		{
			this.tweening = false;
		}

		return pion;
	}

	BoardGame.prototype.createSection = function(d)
	{
		var section = new jeuEurope.Button(
			getTexture("gameBoard", d.id + "Up"),
			getTexture("gameBoard", d.id + "Down"),
			getTexture("gameBoard", d.id + "Hover"),
			this.setupPressCard(d.id));

		section.anchor.set(0.5,0.5);
		this.sections.push(section);
		this.addChild(section);

		section.x = d.x;
		section.y = d.y;

		var textCard = new Text(
			getText("boardGame",d.id),
			{
				font:"16px monstro",
				fill:0x0d437f,
				align:"center",
				stroke:0xffffff,
				strokeThickness:0,
				wordWrap:true,
				wordWrapWidth:section.width-20
			});
		if(textCard.width > 130)
			textCard.scale.set(0.75,0.75);
		textCard.position.set(3,-3);
		textCard.anchor.set(0.5,0.5);
		section.addChild(textCard);

		section.tweening = false;

		section.tweenOut = function()
		{
			var t = new Tween(this,"scale.x",1.0,50,true);	
			t.easing = Tween.inOutCubic;

			t = new Tween(this,"scale.y",1.0,50,true);	
			t.easing = Tween.inOutCubic;
			t.setOnComplete(this.tweenIn.bind(this));
		}

		section.tweenIn = function()
		{
			if(this.tweening)
			{
				var t = new Tween(this,"scale.x",0.9,50,true);
				t.easing = Tween.inOutCubic;

				t = new Tween(this,"scale.y",0.9,50,true);
				t.easing = Tween.inOutCubic;
				t.setOnComplete(this.tweenOut.bind(this));
			}
		}

		section.startTween = function()
		{
			this.tweening = true;
			this.tweenIn();
		}

		section.stopTween = function()
		{
			this.tweening = false;

		}

		return section;
	}

	BoardGame.prototype.createDice = function()
	{
		var dice = new Container();
		dice.interactive = true;

		for(var i=1; i <= 6 ; i++)
		{
			dice["d"+i] = new Sprite(getTexture("gameBoard","dice"+i));
			dice["d"+i].anchor.set(0.5,0.5);
			dice.addChild(dice["d"+i]);
		}

		dice.showFace = function(id)
		{
			this.hideFaces();

			this["d"+id].visible = true;
		}

		dice.hideFaces = function()
		{
			for(var i=1; i <= 6 ; i++)
			{
				this["d"+i].visible = false;
			}
		}

		dice.roll = function(callback)
		{
			this.rotation = 0;

			createjs.Sound.play("roulette");

			var tweenRotate = new Tween(this,"rotation",deg2Rad(720),60,true);
			tweenRotate.easing = Tween.outCubic;
			tweenRotate.setOnComplete(callback);
		}

		dice.gigle = function()
		{
			this.rotation = 0;

			var tweenLeft1 = new Tween(this,"rotation",deg2Rad(-15),10,false);
			var tweenRight1 = new Tween(this,"rotation",deg2Rad(15),20,false);
			var tweenLeft2 = new Tween(this,"rotation",deg2Rad(-15),20,false);
			var tweenRight2 = new Tween(this,"rotation",deg2Rad(15),20,false);
			var tweenCenter = new Tween(this,"rotation",deg2Rad(0),10,false);

			var tweens = new ChainedTween(
				[
					tweenLeft1,
					tweenRight1,
					tweenLeft2,
					tweenRight2,
					tweenCenter
				]);
		}

		dice.showFace(6);

		return dice;
	}

	BoardGame.prototype.arcCercle = function(xc,yc,r)
	{
		var ret = [];

	    var x = 0;
	    var y = r;
	    var d = r - 1;

	    while (y >= x)
	    {
	        ret.push({x:xc + x, y:yc - y + r});

	        if (d >= 2 * x)
	        {
	            d -= 2 * x + 1;
	            x++;
	        }
	        else if (d < 2 * (r - y))
	        {
	            d += 2 * y - 1;
	            y--;
	        }
	        else
	        {
	            d += 2 * (y - x - 1);
	            y--;
	            x++;
	        }
	    }

	    return ret;
	}

	BoardGame.prototype.beginTurn = function()
	{	
		if(this.playerTurn == undefined) this.playerTurn = 0;
		else this.playerTurn = (this.playerTurn + 1) % this.listPlayers.length;

		this.waitDice = false;

		this.header.deselectAll();
		this.header.playersUi[this.playerTurn].select();
		this.pionsContainer.addChild(this.pions[this.playerTurn]);
		this.pions[this.playerTurn].startTween();

		this.dice.gigle();
	}

	BoardGame.prototype.setupPressCard = function(id)
	{
		return function()
		{
			this.onPressCard(id);	
		}.bind(this);
	}

	BoardGame.prototype.onPressCard = function(id)
	{
		if(this.jokerWindow.visible)
		{
			this.openQuestDefi(id);
		}
	}

	BoardGame.prototype.onPressDice = function()
	{	
		if(this.waitDice)
			return;

		this.waitDice = true;

		this.pions[this.playerTurn].stopTween();

		var roll = ((Math.random() * 10000 | 0) % 6) + 1;

		var randRes = 
		{
			1:0,
			2:0,
			3:0,
			4:0,
			5:0,
			6:0
		};

		for(var i = 0; i < 100000 ; i++)
		{
			var res = ((Math.random() * 10000 | 0) % 6) + 1;
			randRes[res]++;
		}

		/*console.log("Preuve aléatoire, sur 100,000 jets de dés voici la répartition des résultats : ");
		console.log(randRes);*/

		var endRoll = function()
		{
			this.movePion(this.playerTurn,roll,this.endMove.bind(this));
		}

		this.dice.showFace(roll);
		this.dice.roll(endRoll.bind(this));
	}

	BoardGame.prototype.movePion = function(idPion,amount,callback)
	{
		var pion = this.pions[idPion];
		var oldCase = pion.actualCase;

		pion.actualCase += amount;
		pion.actualCase = Math.min(pion.actualCase,this.boardGameData.cases.length-1);

		var tweensX = [];
		var tweensY = [];

		for(var i=1;i<=pion.actualCase-oldCase;i++)
		{
			var c = this.boardGameData.cases[oldCase+i];
			var tx = new Tween(pion,"x",c.x,45,false);
			var ty = new Tween(pion,"y",c.y,45,false);

			tx.easing = Tween.inOutCubic;
			ty.easing = Tween.inOutCubic;

			tweensX.push(tx);
			tweensY.push(ty);

			tx.setOnComplete(function()
			{
				createjs.Sound.play("poc");
			})
		}

		var bigTX = new ChainedTween(tweensX);
		var bigTY = new ChainedTween(tweensY);

		if(callback) 
			bigTX.setOnComplete(callback.bind(this));
	}

	BoardGame.prototype.openQuestDefi = function(typeCase)
	{
		//typeCase = "peine";

		var data = getContent(typeCase);

		if(!this.questionDone[typeCase] ||
			this.questionDone[typeCase].length == data.quest.length + data.defi.length + data.ouv.length) 
			this.questionDone[typeCase] = [];

		var rand = ((Math.random() * (data.quest.length + data.defi.length + data.ouv.length)) | 0);
		while(this.questionDone[typeCase].indexOf(rand) != -1)
			 rand = ((Math.random() * (data.quest.length + data.defi.length + data.ouv.length)) | 0);

		//rand = 2;

		this.questionDone[typeCase].push(rand);

		createjs.Sound.play("open");

		if(rand < data.quest.length)
		{
			var quest = data.quest[rand];

			//console.log(quest);

			this.questWindow = new jeuEurope.QuestWindow(
				quest,
				this.endQuestion.bind(this));

			this.addChild(this.questWindow);
		}
		else if(rand < data.defi.length + data.quest.length)
		{
			var defi = data.defi[rand - data.quest.length];

			//console.log(defi);

			this.defiWindow = new jeuEurope.DefiWindow(
				defi,
				this.endDefi.bind(this));

			this.addChild(this.defiWindow);
		}
		else
		{
			var ouv = data.ouv[rand - data.quest.length - data.defi.length];

			//console.log(ouv);

			this.ouvWindow = new jeuEurope.OuvWindow(
				ouv,
				this.endQuestion.bind(this));

			this.addChild(this.ouvWindow);
		}
	}

	BoardGame.prototype.endMove = function()
	{
		var delayed = function()
		{
			var typeCase = this.boardGameData.cases[this.pions[this.playerTurn].actualCase].type;

			//console.log(typeCase);

			var validCases = 
			[
				"div",
				"lib",
				"elec",
				"peine",
				"jus",
				"egal"
			];

			if(validCases.indexOf(typeCase) != -1)
			{
				this.openQuestDefi(typeCase);
			}
			else if(typeCase == "joker")
			{
				this.showJoker();
			}
			else if(typeCase == "end")
			{
				this.onEndGame();
			}

		}.bind(this);
		
		setTimeout(delayed,500);
	}

	BoardGame.prototype.showJoker = function()
	{
		createjs.Sound.play("joker");

		this.jokerWindow.visible = true;

		for (var i = 0; i < this.sections.length; i++) {
			this.sections[i].startTween();
		}
	}

	BoardGame.prototype.endQuestion = function(result)
	{
		var reachedEnd = false;

		this.jokerWindow.visible = false;

		for (var i = 0; i < this.sections.length; i++) {
			this.sections[i].stopTween();
		}

		if(this.questWindow)
		{
			this.removeChild(this.questWindow);
			this.questWindow = undefined;
		}
		if(this.ouvWindow)
		{
			this.removeChild(this.ouvWindow);
			this.ouvWindow = undefined;
		}

		var ref = this;

		var after = function()
		{
			if(!reachedEnd)
				ref.endTurn();
			else
				ref.onEndGame();
		}

		if(result.answer)
		{
			var pion = this.pions[this.playerTurn];

			this.movePion(this.playerTurn,result.effect,after);

			pion.scores.total++;
			pion.scores[result.data.type.normalize()]++;

			this.header.playersUi[this.playerTurn].addScore(1);

			if(this.boardGameData.cases[pion.actualCase].type == "end")
			{
				reachedEnd = true;
				pion.scores.reachedEnd = true;
			}
		}
		else
		{
			after();
		}
	}

	BoardGame.prototype.endDefi = function(result)
	{
		var oneReachedEnd = false;

		this.jokerWindow.visible = false;

		this.removeChild(this.defiWindow);

		for (var i = 0; i < this.sections.length; i++) {
			this.sections[i].stopTween();
		}

		this.defiWindow = undefined;

		var after = function()
		{
			if(!oneReachedEnd)
				this.endTurn();
			else
				this.onEndGame();
		}

		for (var i = 0; i < this.pions.length; i++) {
			var pion = this.pions[i];

			if(result.validPlayers.indexOf(pion.data.id) != -1)
			{
				this.movePion(i,result.effect);

				pion.scores.total++;
				pion.scores[result.data.type.normalize()]++;

				this.header.playersUi[i].addScore(1);

				if(this.boardGameData.cases[pion.actualCase].type == "end")
				{
					oneReachedEnd = true;
					pion.scores.reachedEnd = true;
				}
			}
		};

		setTimeout(after.bind(this),750 * result.validPlayers.length);
	}

	BoardGame.prototype.endTurn = function()
	{
		this.beginTurn();
	}

	BoardGame.prototype.onEndGame = function()
	{
		this.gameEnded = true;
		var scores = [];

		for (var i = 0; i < this.pions.length; i++) {
			var pion = this.pions[i];

			scores.push(
			{
				name:pion.data.name,
				school:pion.data.school,
				id:pion.data.id,
				score:pion.scores,
				case:pion.actualCase
			});
		};

		this.endWindow = new jeuEurope.EndWindow(scores,this.onExitLeaderBoard.bind(this));
		this.addChild(this.endWindow);
	}

	BoardGame.prototype.onExitLeaderBoard = function()
	{
		jeuEurope.current.openHome();
	}

	BoardGame.prototype.update = function()
	{
		if(this.defiWindow) this.defiWindow.update();
		if(this.questWindow) this.questWindow.update();
		if(this.ouvWindow) this.ouvWindow.update();
	}

	BoardGame.prototype.close = function()
	{
		
	}

}(jeuEurope));
