var jeuEurope = jeuEurope || {};

(function(jeuEurope){

	jeuEurope.GameUi = GameUi;

	//héritage
	GameUi.prototype = Object.create(Container.prototype);

	function GameUi(listPlayers)
	{
		//constructeur parent
		Container.call(this);

		//propriétés
		this.playersUi = {
			length:0
		};

		this.header = undefined;

		this.btnHome = undefined;
		this.listPlayers = listPlayers;

		//construction
		this.header = new Sprite(getTexture("gameUi","header"));
		this.addChild(this.header);


		this.btnHome = new jeuEurope.Button(
			getTexture("gameUi","btnHomeUp"),
			getTexture("gameUi","btnHomeDown"),
			getTexture("gameUi","btnHomeHover"),
			this.onPressHome.bind(this));
		this.addChild(this.btnHome);
		this.btnHome.anchor.set(0,0.5);
		this.btnHome.position.set(15,67);


		var spaceBetweenElement = 175;
		var totalWidth = (spaceBetweenElement * (listPlayers.length-1));
		var start = (jeuEurope.appParam.stageWidth - totalWidth)/2;

		for (var i = 0; i < listPlayers.length; i++) {
			var player = listPlayers[i];

			var uiElement = this.createPlayer(player);
			this.playersUi[i] = uiElement;
			this.addChild(uiElement);

			uiElement.x = start + spaceBetweenElement * i;
			uiElement.y = 50;

			this.playersUi.length++;
		};
		
	}	

	GameUi.prototype.createPlayer = function(data)
	{
		var contain = new Container();

		var team = new Sprite(getTexture("gameUi","team"+data.id));
		team.anchor.set(0.5,0.5);
		contain.addChild(team);

		team.x = -30;

		var haloSelect = new Sprite(getTexture("gameUi","haloSelect"));
		haloSelect.anchor.set(0.5,0.5);
		team.addChild(haloSelect);

		var starContain = new Container();
		starContain.x  = 30;
		contain.addChild(starContain);

		var star = new Sprite(getTexture("gameUi","starOff"));
		star.anchor.set(0.5,0.5);
		starContain.addChild(star);

		var textScore = new Text("0",
			{
				font:"22px robotor",
				fill:0xffffff,
				align:"center"
			});

		textScore.anchor.set(0.5,0.5);
		starContain.addChild(textScore);

		var fondName = new Sprite(getTexture("gameUi","fondName"));
		fondName.anchor.set(0.5,0.5);
		starContain.addChild(fondName);

		fondName.x = -40;
		fondName.y = 50;

		var textName = new Text(data.name,
			{
				font:"22px robotor",
				fill:0x0d437f,
				align:"center"
			});
		textName.anchor.set(0.5,0.5);
		fondName.addChild(textName);

		contain.haloSelect = haloSelect;
		contain.star = star;
		contain.textScore = textScore;
		contain.scoreValue = 0;

		contain.select = function()
		{
			this.startTween();
			this.haloSelect.visible = true;
		}

		contain.deselect = function()
		{
			this.stopTween();
			this.haloSelect.visible = false;
		}

		contain.getScore = function()
		{
			return this.scoreValue;
		}

		contain.addScore = function(val)
		{
			this.scoreValue += val;
			this.textScore.text = this.scoreValue;
		}

		contain.tweening = false;

		contain.tweenOut = function()
		{
			var t = new Tween(this,"scale.x",1.0,50,true);	
			t.easing = Tween.inOutCubic;

			t = new Tween(this,"scale.y",1.0,50,true);	
			t.easing = Tween.inOutCubic;
			t.setOnComplete(this.tweenIn.bind(this));
		}

		contain.tweenIn = function()
		{
			if(this.tweening)
			{
				var t = new Tween(this,"scale.x",0.9,50,true);
				t.easing = Tween.inOutCubic;

				t = new Tween(this,"scale.y",0.9,50,true);
				t.easing = Tween.inOutCubic;
				t.setOnComplete(this.tweenOut.bind(this));
			}
		}

		contain.startTween = function()
		{
			this.tweening = true;
			this.tweenIn();
		}

		contain.stopTween = function()
		{
			this.tweening = false;
		}

		contain.deselect();

		return contain;
	}

	GameUi.prototype.update = function()
	{
		
	}

	GameUi.prototype.deselectAll = function()
	{
		for (var i = 0; i < this.playersUi.length; i++) {
			this.playersUi[i].deselect();
		};
	}

	GameUi.prototype.onPressHome = function()
	{
		//TODO ouvrir popup confirmation
		jeuEurope.current.openHome();
	}

}(jeuEurope));