window.Keyboard = Keyboard;

function Keyboard (keyCode) {
    this.code = keyCode;
    this.isDown = false;
    this.isUp = true;
    this.press = undefined;
    this.release = undefined;

    this.bindedDown = this.downHandler.bind(this);
    this.bindedUp = this.upHandler.bind(this);

    this.add();
}   

Keyboard.prototype.downHandler = function(event) {
    if (event.keyCode === this.code) {
        if (this.isUp && this.press) this.press();
        this.isDown = true;
        this.isUp = false;
    }
};


Keyboard.prototype.upHandler = function(event) {
    if (event.keyCode === this.code) {
        if (this.isDown && this.release) this.release();
        this.isDown = false;
        this.isUp = true;
    }
};

Keyboard.prototype.add = function(){
    //Attach event listeners
    window.addEventListener(
        "keydown", this.bindedDown, false
    );
    window.addEventListener(
        "keyup", this.bindedUp, false
    );
}

Keyboard.prototype.remove = function() {
    if (window.removeEventListener) {                   
        window.removeEventListener("keydown", this.bindedDown);
        window.removeEventListener("keyup", this.bindedUp);
    } else if (window.detachEvent) {                    
        window.detachEvent("keydown", this.bindedDown);
        window.detachEvent("keyup", this.bindedUp);
    }
}

/**

The keyboard function is easy to use. Create a new keyboard object like this:

var keyObject = new Keyboard(asciiKeyCodeNumber);
It's one argument is the ASCII key code number of the keyboad key that you want to listen for. Here's a list of ASCII keyboard code numbers.

Then assign press and release methods to the keyboard object like this:

keyObject.press = function() {
  //key object pressed
};
keyObject.release = function() {
  //key object released
};


*/
