var jeuEurope = jeuEurope || {};

(function(jeuEurope){

	jeuEurope.SettingsWindow = SettingsWindow;

	//héritage
	SettingsWindow.prototype = Object.create(Container.prototype);

	function SettingsWindow(callbackExit)
	{
		//constructeur parent
		Container.call(this);

		//bloque les event "derriere" la fenetre
		this.interactive = true;

		//propriétés
		this.btnExit = undefined;
		this.window = undefined;
		this.callbackExit = callbackExit;
		this.titre = undefined;

		this.titreChrono = undefined;
		this.titreLangue = undefined;

		this.selectLangue = undefined;
		this.selectChrono = undefined;

		//----- Visual -----
		this.window = new Sprite(getTexture("settingsWindow","window"));
		this.window.interactive = true;
		this.addChild(this.window);

		this.btnExit = new jeuEurope.Button(
			getTexture("settingsWindow","btnExitUp"),
			getTexture("settingsWindow","btnExitDown"),
			getTexture("settingsWindow","btnExitHover"),
			this.onPressExit.bind(this));

		this.addChild(this.btnExit);

		this.btnExit.anchor.set(0.5,0.5);
		this.btnExit.position.set(jeuEurope.appParam.stageWidth - 50, 50);

		this.titre = new Text(
			getText("settingsWindow","titre"),
			{
				font:"36px robotor",
				fill:0xffffff,
				align:"center",
				lineHeight:80
			});
		this.addChild(this.titre);
		this.titre.anchor.set(0.5,0);
		this.titre.position.set(jeuEurope.appParam.stageWidth/2, 115);

		this.titreChrono = new Text(
			getText("settingsWindow","titreChrono"),
			{
				font:"24px robotor",
				fill:0xffce05,
				align:"left",
				wordWrap:true,
				wordWrapWidth:450
			});
		this.addChild(this.titreChrono);
		this.titreChrono.position.set(505,180);

		this.titreLangue = new Text(
			getText("settingsWindow","titreLangue"),
			{
				font:"24px robotor",
				fill:0xffce05,
				align:"left",
				wordWrap:true,
				wordWrapWidth:450
			});
		this.addChild(this.titreLangue);
		this.titreLangue.position.set(505,470);

		//----- Selects ------

		this.selectChrono = new PIXI.Select(
			{
				options:{
					5:"5 mn",
					10:"10 mn"
				},
				selected:jeuEurope.Datas.chronoDuration,
			    width: 300,
			    borderWidth:1,
			    borderColor:"#fff",
			    backgroundGradient: [ "#e0e0e0", "#fdfdfd", "#e0e0e0" ],
			    text: {
			        font: "30px robotor",
			        fill: "#0e3d8a",
			        align: "left"
			    },
			    optionText: {
			        font: "26px robotor",
			        fill: "#0e3d8a",
			        align: "left"
			    }
			});

		this.addChild(this.selectChrono);

		this.selectChrono.position.set(500,285);


		this.selectLangue = new PIXI.Select(
			{	
				options:jeuEurope.validLanguages,
				selected:jeuEurope.language,
			    width: 300,
			    borderWidth:1,
			    borderColor:"#fff",
			    backgroundGradient: [ "#e0e0e0", "#fdfdfd", "#e0e0e0" ],
			    text: {
			        font: "30px robotor",
			        fill: "#0e3d8a",
			        align: "left"
			    },
			    optionText: {
			        font: "26px robotor",
			        fill: "#0e3d8a",
			        align: "left"
			    }
			});

		this.addChild(this.selectLangue);

		this.selectLangue.position.set(500,550);

		this.window
			.on("touchstart", this.blurSelect.bind(this))
			.on("mousedown",  this.blurSelect.bind(this));

		this.selectLangue
			.on("touchstart", this.blurChrono.bind(this))
			.on("mousedown", this.blurChrono.bind(this));
			
		this.selectChrono	
			.on("touchstart", this.blurLangue.bind(this))
			.on("mousedown", this.blurLangue.bind(this));

		this.escape = new Keyboard(27);
		this.escape.press = this.onPressExit.bind(this);
		this.space = new Keyboard(32);
		this.space.press = this.onPressExit.bind(this);
	}	

	SettingsWindow.prototype.blurSelect = function()
	{
		this.selectLangue.blur();
		this.selectChrono.blur();
	}

	SettingsWindow.prototype.blurLangue = function()
	{
		this.selectLangue.blur();
	}

	SettingsWindow.prototype.blurChrono = function()
	{
		this.selectChrono.blur();
	}


	SettingsWindow.prototype.update = function()
	{
		
	}

	SettingsWindow.prototype.onPressExit = function()
	{	
		createjs.Sound.play("bouton");

		jeuEurope.language = this.selectLangue.value.value;
		jeuEurope.Datas.chronoDuration = this.selectChrono.value.value;

		this.escape.remove();
		this.space.remove();
		
		this.callbackExit();
	}


}(jeuEurope));