var jeuEurope = jeuEurope || {};

(function(jeuEurope){

	jeuEurope.QuestWindow = QuestWindow;

	//héritage
	QuestWindow.prototype = Object.create(Container.prototype);

	function QuestWindow(questData,callbackEnd)
	{
		//constructeur parent
		Container.call(this);

		this.interactive = true;

		//propriétés
		this.greyBackground = undefined;
		this.windowQuest = undefined;
		this.questData = questData;
		this.windowExpl = undefined;
		this.btnValid = undefined;
		this.textBtnValid = undefined;
		this.titre = undefined;
		this.intro = undefined;
		this.icone = undefined;
		this.question = undefined;
		this.goodAnswer = questData.repok[0];
		this.listRep = [];
		this.selectedAnswer = "";
		this.validated = false;
		this.callbackEnd = callbackEnd;

		//construction
		//fenetres
		this.greyBackground = new Graphics();
		this.greyBackground.beginFill(0x000000,0.77);
		this.greyBackground.drawRect(0,0,jeuEurope.appParam.stageWidth,jeuEurope.appParam.stageHeight);
		this.greyBackground.endFill();
		this.addChild(this.greyBackground);

		this.windowQuest = new Sprite(getTexture("questWindow","window"+questData.type));
		this.windowQuest.anchor.set(0.5,0.5);
		this.windowQuest.position.set(
			jeuEurope.appParam.stageWidth / 2,
			jeuEurope.appParam.stageHeight / 2);
		this.addChild(this.windowQuest);

		//----- window content
		this.titre = new Text(
			questData.titre,
			{
				font:"24px robotor",
				fill:0x183f87,
				align:"left",
				wordWrap:true,
				wordWrapWidth:480
			});
		this.titre.position.set(-136,-305);
		this.windowQuest.addChild(this.titre);

		this.intro = new Text(
			questData.intro,
			{
				font:"18px robotor",
				fill:0x183f87,
				align:"left",
				wordWrap:true,
				wordWrapWidth:480
			});
		this.intro.position.set(-136,this.titre.y + this.titre.height + 5);
		this.windowQuest.addChild(this.intro);

		this.icone = new Sprite(getTexture("questWindow","icone"));
		this.icone.anchor.set(0.5,0.5);
		this.icone.position.set(-280,Math.max(-35, this.intro.y + this.intro.height + 20));
		this.windowQuest.addChild(this.icone);

		this.question = new Text(
			questData.quest,
			{
				font:"22px robotor",
				fill:0x183f87,
				align:"left",
				wordWrap:true,
				wordWrapWidth:550
			});
		this.question.position.set(-215,Math.max(-35, this.intro.y + this.intro.height + 20));
		this.question.anchor.set(0,0.5);
		this.windowQuest.addChild(this.question);

		this.question.wordWrap(questData.quest);

		//------- reponses
		//créé les lignes interactives
		var reps = [];
		reps.push(this.createRep(questData.repok));
		for (var i = 0; i < questData.rep.length; i++) {
			reps.push(this.createRep(questData.rep[i]));
		};
		
		//les tri dans l'ordre de l'alphabet
		var letters = ["A","B","C"];
		var iLettre = 0;
		var antiInfinite = 10;
		while(reps.length > 0 && antiInfinite > 0)
		{
			for (var i = 0; i < reps.length; i++) {
				//console.log("1ere lettre : "+reps[i].repText.text[0] + " - lettreTest : "+ letters[iLettre]+ " - isSame : "+(reps[i].repText.text[0] == letters[iLettre]));
				if(reps[i].repText.text[0] == letters[iLettre])
				{
					this.listRep.push(reps[i]);
					iLettre++;
					reps.splice(i,1);
					break;
				}
			};

			antiInfinite--;
		}

		//les affiche et positionne
		for (var i = 0; i < this.listRep.length; i++) {
			this.windowQuest.addChild(this.listRep[i]);
			this.listRep[i].position.set(-280, 55 + 90 * i);
			this.listRep[i].on("mouseup",this.setupPressRep(this.listRep[i].repText.text[0]).bind(this));
			this.listRep[i].on("touchend",this.setupPressRep(this.listRep[i].repText.text[0]).bind(this));
		};

		//------- Explication reponse

		this.windowExpl = new Sprite(getTexture("questWindow","windowExpl"));
		this.windowExpl.anchor.set(0.5,0.5);
		this.windowExpl.position.set(1040,540);
		this.windowExpl.visible = false;
		this.addChild(this.windowExpl);

		var expl = questData.expl.split(" : ");

		this.titreExpl = new Text(
			expl.length > 1 ? expl[0] : getText("questWindow","titreExpl"),
			{
				font:"24px robotor",
				fill:0x183f87,
				align:"center"
			});
		this.titreExpl.anchor.set(0.5,0.5);
		this.titreExpl.position.set(0,-110);

		this.windowExpl.addChild(this.titreExpl);

		this.explText = new Text(
			expl.length > 1 ? questData.expl.split(" : ")[1] : questData.expl,
			{
				font:"18px robotor",
				fill:0x183f87,
				align:"center",
				wordWrap: true,
				wordWrapWidth:400
			});
		this.explText.anchor.set(0.5,0.5);
		this.windowExpl.addChild(this.explText);

		//------ Picto reponse Good

		this.goodContain = new Container();
		this.goodContain.position.set(1040,200);
		this.goodContain.visible = false;
		this.addChild(this.goodContain);

		this.pictoGood = new Sprite(getTexture("questWindow","goodAnswer"));
		this.pictoGood.anchor.set(0.5,0.5);
		this.goodContain.addChild(this.pictoGood);

		this.goodTitle = new Text(
			getText("questWindow","goodAnswerTitle"),
			{
				font:"39px robotor",
				fill:0x95c121,
				align:"center"
			});

		this.goodTitle.anchor.set(0.5,0.5);
		this.goodTitle.position.set(0,this.pictoGood.height / 2 + 25);
		this.goodContain.addChild(this.goodTitle);

		this.goodText = new Text(
			getText("questWindow","goodAnswerText"+questData.caseEffect),
			{
				font:"28px robotor",
				fill:0xffffff,
				align:"center"
			});
		this.goodText.anchor.set(0.5,0.5);
		this.goodText.position.set(0,this.pictoGood.height / 2 + 65);
		this.goodContain.addChild(this.goodText);

		this.goodEffectText = new Text(
			"+"+questData.caseEffect,
			{
				font:"64px robotor",
				fill:0xffffff,
				align:"center",
				dropShadow:true
			});
		this.goodEffectText.anchor.set(0.5,0.5);
		this.goodEffectText.y = 5;
		this.goodContain.addChild(this.goodEffectText);

		//------ Picto reponse Bad

		this.badContain = new Container();
		this.badContain.position.set(1040,200);
		this.badContain.visible = false;
		this.addChild(this.badContain);

		this.pictoBad = new Sprite(getTexture("questWindow","badAnswer"));
		this.pictoBad.anchor.set(0.5,0.5);
		this.badContain.addChild(this.pictoBad);

		this.badTitle = new Text(
			getText("questWindow","badAnswerTitle"),
			{
				font:"39px robotor",
				fill:0xf21c1d,
				align:"center"
			});

		this.badTitle.anchor.set(0.5,0.5);
		this.badTitle.position.set(0,this.pictoBad.height / 2 + 25);
		this.badContain.addChild(this.badTitle);

		this.badText = new Text(
			getText("questWindow","badAnswerText"),
			{
				font:"28px robotor",
				fill:0xffffff,
				align:"center"
			});
		this.badText.anchor.set(0.5,0.5);
		this.badText.position.set(0,this.pictoBad.height / 2 + 65);
		this.badContain.addChild(this.badText);
		
		//-------boutons
		this.btnValid = new jeuEurope.Button(
			getTexture("questWindow","btnValidUp"),
			getTexture("questWindow","btnValidDown"),
			getTexture("questWindow","btnValidHover"),
			this.onPressValid.bind(this));
		this.btnValid.anchor.set(0.5,0.5);
		this.btnValid.position.set(0, this.windowQuest.height / 2);
		this.windowQuest.addChild(this.btnValid);

		this.textBtnValid = new Text(
			getText("questWindow","btnValid"),
			{
				font:"16px robotor",
				fill:0xffffff,
				align:"center",
				stroke:0x409e01, 
				strokeThickness:3
			});
		this.textBtnValid.anchor.set(0.5,0.5);
		this.btnValid.addChild(this.textBtnValid);
		this.btnValid.visible = false;

		this.btnExit = new jeuEurope.Button(
			getTexture("questWindow","btnExitUp"),
			getTexture("questWindow","btnExitDown"),
			getTexture("questWindow","btnExitHover"),
			this.onPressExit.bind(this));

		this.btnExit.position.set(1200,80);
		this.btnExit.visible = false;

		this.addChild(this.btnExit);

		this.escape = new Keyboard(27);
		this.escape.press = this.onPressExit.bind(this);
		this.space = new Keyboard(32);
		this.space.press = this.onPressExit.bind(this);

	}	

	QuestWindow.prototype.createRep = function(reponse)
	{
		var rep = new Container();
		rep.interactive = true;

		rep.btnRadio = new Sprite(getTexture("questWindow","btnRadioOff"));
		rep.btnRadio.anchor.set(0.5,0.5);
		rep.addChild(rep.btnRadio);

		rep.repText = new Text(
			reponse,
			{
				font:"21px robotor",
				fill:0x183f87,
				align:"left",
				wordWrap:true,
				wordWrapWidth:550
			});
		rep.repText.anchor.set(0,0.5);
		rep.repText.position.set(rep.btnRadio.width + 8,0);
		rep.addChild(rep.repText);

		rep.select = function()
		{
			this.btnRadio.texture = getTexture("questWindow","btnRadioOn");
		}

		rep.deselect = function()
		{
			this.btnRadio.texture = getTexture("questWindow","btnRadioOff");
		}

		rep.validate = function()
		{
			this.btnRadio.texture = getTexture("questWindow","btnRadioGood");
		}

		rep.invalidate = function()
		{
			this.btnRadio.texture = getTexture("questWindow","btnRadioBad");
		}

		return rep;
	}

	QuestWindow.prototype.setupPressRep = function(id)
	{
		return function()
		{
			this.onPressRep(id);	
		}.bind(this);
	}

	QuestWindow.prototype.onPressRep = function(id)
	{	
		if(this.validated)
			return;

		createjs.Sound.play("bouton");

		this.deselectAll();

		this.selectedAnswer = id;

		for (var i = 0; i < this.listRep.length; i++) {
			if(this.listRep[i].repText.text[0] == id)
			{
				this.listRep[i].select();
				break;
			}
		};

		this.btnValid.visible = true;
	}

	QuestWindow.prototype.deselectAll = function()
	{
		for (var i = 0; i < this.listRep.length; i++) {
			this.listRep[i].deselect();
		};
	}

	QuestWindow.prototype.onPressValid = function()
	{
		if(!this.btnValid.visible)
			return;

		createjs.Sound.play("bouton");

		if(this.selectedAnswer == this.goodAnswer)
		{
			createjs.Sound.play("etoile");
		}
		else
		{
			createjs.Sound.play("echec");
		}

		this.btnValid.visible = false;

		for (var i = 0; i < this.listRep.length; i++) {
			if(this.listRep[i].repText.text[0] == this.selectedAnswer)
			{
				if(this.selectedAnswer == this.goodAnswer)
					this.listRep[i].validate();
				else
					this.listRep[i].invalidate();

				break;
			}
		};

		this.validated = true;

		var tweenWindow = new Tween(this.windowQuest,"x",420,60,true);
		tweenWindow.easing = Tween.inOutCubic;
		tweenWindow.setOnComplete(this.showRepExplained.bind(this));
	}

	QuestWindow.prototype.showRepExplained = function()
	{
		this.windowExpl.visible = true;
		this.btnExit.visible = true;

		this.goodContain.visible = (this.selectedAnswer == this.goodAnswer);
		this.badContain.visible = (this.selectedAnswer != this.goodAnswer);
	}	

	QuestWindow.prototype.onPressExit = function(e)
	{
		if(!this.btnExit.visible)
			return;

		this.escape.remove();
		this.space.remove();
		
		createjs.Sound.play("bouton");
		this.callbackEnd(
			{
				answer:this.selectedAnswer == this.goodAnswer,
				effect:this.questData.caseEffect,
				data:this.questData
			});
	}

	QuestWindow.prototype.update = function()
	{
		
	}

}(jeuEurope));