var jeuEurope = jeuEurope || {};

(function(jeuEurope){

	jeuEurope.AudioLoader = AudioLoader;

	function AudioLoader() 
	{	
		this.audios                = {};
		this.numberAudioToLoad     = 0;
		this.numberAudioLoaded     = 0;
		this.audioEndCallback      = undefined;    
	}

	AudioLoader.prototype.loadSounds = function (loadEndCallback)
	{
		createjs.Sound.initializeDefaultPlugins();
		createjs.Sound.alternateExtensions = ["mp3"];
		createjs.Sound.on("fileload", this.handleSoundLoad.bind(this));
		createjs.Sound.on("fileerror", this.handleSoundError.bind(this));


		this.audioEndCallback      = loadEndCallback;
		this.numberAudioLoaded     = 0;
		this.numberAudioToLoad     = 0;


		this.addAudio("./assets/sounds/effects/echec.mp3" ,"echec");
		this.addAudio("./assets/sounds/effects/etoile.mp3" ,"etoile");
		this.addAudio("./assets/sounds/effects/open.mp3" ,"open");
		this.addAudio("./assets/sounds/effects/gong.mp3" ,"gong");
		this.addAudio("./assets/sounds/effects/bouton.mp3" ,"bouton");
		this.addAudio("./assets/sounds/effects/joker.mp3" ,"joker");
		this.addAudio("./assets/sounds/effects/poc.mp3" ,"poc");
		this.addAudio("./assets/sounds/effects/roulette.mp3" ,"roulette");

		this.addAudio("./assets/sounds/musics/hiphop.mp3" ,"hiphop");
		this.addAudio("./assets/sounds/musics/techno.mp3" ,"techno");
	}

	AudioLoader.prototype.addAudio = function(path,id)
	{
		this.numberAudioToLoad++;
		createjs.Sound.registerSound(path,id);
	}


	AudioLoader.prototype.handleSoundLoad = function(e)
	{
		this.numberAudioLoaded++;

		if(this.numberAudioLoaded == this.numberAudioToLoad)
			this.audioEndCallback();
	}

	AudioLoader.prototype.handleSoundError = function(e)
	{
		this.numberAudioLoaded++;

		trace("Unable to load sound : "+e.src);

		if(this.numberAudioLoaded == this.numberAudioToLoad)
			this.audioEndCallback();
	}

	jeuEurope.audioLoader = new AudioLoader();

}(jeuEurope));