function getRealPos(obj, target) {
    var parent = obj;

    var posX = obj.x;
    var posY = obj.y;

    while((parent = parent.parent) != target)
    {
        posX += parent.x;
        posY += parent.y;
    }

    return {x:posX, y:posY};
}

function setRealPos(obj, pos, target) {
    var parent = obj;

    var posX = pos.x;
    var posY = pos.y;

    while((parent = parent.parent) != target)
    {
        posX -= parent.x;
        posY -= parent.y;
    }

    obj.x = posX;
    obj.y = posY;
}

function getTexture(group, id)
{
    if(TextureCache[group+"/"+id])
        return TextureCache[group+"/"+id];
    else
    {
        console.log("le groupe "+group+" ou l'id "+id+" n'existe pas");
    }
}

function getText(group,id)
{
    return jeuEurope.textLoader.getText(group,id);
}

function getLanguage()
{
    return jeuEurope.language;
}

function getContent(group)
{
    return jeuEurope.textLoader.getContent(group);
}

function rad2Deg(val)
{
    return PIXI.RAD_TO_DEG * val;
}

function deg2Rad(val)
{
    return PIXI.DEG_TO_RAD * val;
}

function shuffleArray(array) {
  var currentIndex = array.length, temporaryValue, randomIndex;

  while (0 !== currentIndex) {

    randomIndex = Math.floor(Math.random() * currentIndex);
    currentIndex -= 1;

    temporaryValue = array[currentIndex];
    array[currentIndex] = array[randomIndex];
    array[randomIndex] = temporaryValue;
  }

  return array;
}

String.prototype.capitalize = function() {
    return this.charAt(0).toUpperCase() + this.slice(1);
}

String.prototype.normalize = function() {
    return this.charAt(0).toLowerCase() + this.slice(1);
}