var jeuEurope = jeuEurope || {};

(function(jeuEurope){

	jeuEurope.App = App;

	function App()
	{
		//propriétés
		this.numberToLoad = 3;
		this.numberLoaded = 0;

		this.home = undefined;
		this.newGame = undefined;
		this.boardGame = undefined;

		this.stage = undefined;

		//démarrage
		this.initialize();
	}

	App.prototype.initialize = function()
	{
		//Créé le canvas initial
		var renderer = PIXI.autoDetectRenderer(
			jeuEurope.appParam.stageWidth,
			jeuEurope.appParam.stageHeight,
			{ antialias: false });

		renderer.view.style.margin = "auto";
		renderer.view.style.top = "0";
		renderer.view.style.bottom = "0";
		renderer.view.style.left = "0";
		renderer.view.style.right = "0";
		renderer.view.style.position = "absolute";

		jeuEurope.appParam.renderer = renderer;
		document.body.appendChild(renderer.view);
		jeuEurope.appParam.canvas = renderer.view;
		PIXI.InputObject.setCanvas(renderer.view);

		jeuEurope.appParam.stage = this.stage = new Container();

		window.onresize = this.onResize;

		this.onResize();

		this.preload();
	}

	App.prototype.preload = function()
	{
		//précharge l'image de fond en 1er
		var background = Sprite.fromImage("./assets/images/common/background.jpg");
		this.stage.addChild(background);

		//précharge les typo
		var polices = [
			"robotor",
			"monstro"
		];

		for (var i = 0; i < polices.length; i++) {
			var p = polices[i];
			var text = new Text("",{font:"30px "+p});
			this.stage.addChild(text);
		};

		//lance la boucle d'update
		requestAnimationFrame(this.update.bind(this));

		//lance le chargement des assets
		this.load();
	}

	App.prototype.load = function()
	{
		PIXI.loader
			.add("home"				,"./assets/images/home/home.json")
			.add("newGame"			,"./assets/images/newGame/newGame.json")
			.add("settingsWindow"	,"./assets/images/settingsWindow/settingsWindow.json")
			.add("infoWindow"		,"./assets/images/infoWindow/infoWindow.json")
			.add("gameUi"			,"./assets/images/gameUi/gameUi.json")
			.add("gameBoard"		,"./assets/images/gameBoard/gameBoard.json")
			.add("questWindow"		,"./assets/images/questWindow/questWindow.json")
			.add("endWindow"		,"./assets/images/endWindow/endWindow.json")
			.add("defiWindow"		,"./assets/images/defiWindow/defiWindow.json")
			.add("./assets/images/endWindow/diplomeen.png")
			.add("./assets/images/endWindow/diplomefr.png")
			.add("./assets/images/endWindow/diplomede.png")
			.add("./assets/images/endWindow/diplomegr.png")

		  	.load(this.onEndLoad.bind(this));

		jeuEurope.textLoader
			.loadXML(this.onEndLoad.bind(this));

		jeuEurope.audioLoader
			.loadSounds(this.onEndLoad.bind(this));
	}

	App.prototype.onEndLoad = function()
	{
		this.numberLoaded++;

		if(this.numberLoaded >=
			this.numberToLoad)
		{
			this.init();
			//setTimeout(this.init.bind(this),10000);
		}
	}

	App.prototype.init = function()
	{
		jeuEurope.textLoader.language = jeuEurope.language;

		this.openHome();
	}

	App.prototype.onResize = function()
	{
		if(jeuEurope.appParam.adjustScale)
		{
			// browser viewport size
			var w = window.innerWidth;
			var h = window.innerHeight;
			
			// keep aspect ratio
			var scale = Math.min(
				w / jeuEurope.appParam.stageWidth, 
				h / jeuEurope.appParam.stageHeight);

			jeuEurope.appParam.scale = scale;

			// adjust canvas size
			jeuEurope.appParam.renderer.view.style.width = 
				jeuEurope.appParam.stageWidth * scale+"px";

			jeuEurope.appParam.renderer.view.style.height = 
				jeuEurope.appParam.stageHeight * scale+"px";
		}
		else
		{
			// keep aspect ratio
			var scale = 1;
			jeuEurope.appParam.scale = scale;

			// adjust canvas size
			jeuEurope.appParam.renderer.view.style.width = 
				jeuEurope.appParam.stageWidth * scale+"px";

			jeuEurope.appParam.renderer.view.style.height = 
				jeuEurope.appParam.stageHeight * scale+"px";
		}
	}

	App.prototype.openHome = function()
	{
		this.cleanScenes();

		this.home = new jeuEurope.Home();
		this.stage.addChild(this.home);
	}

	App.prototype.openNewGame = function()
	{
		this.cleanScenes();

		this.newGame = new jeuEurope.NewGame();
		this.stage.addChild(this.newGame);
	}

	App.prototype.openBoardGame = function(listPlayers)
	{
		this.cleanScenes();

		this.boardGame = new jeuEurope.BoardGame(listPlayers);
		this.stage.addChild(this.boardGame);
	}

	App.prototype.cleanScenes = function()
	{
		if(this.boardGame)
		{	
			this.boardGame.close();
			this.stage.removeChild(this.boardGame);
			this.boardGame = undefined;
		}
		if(this.newGame)
		{
			this.newGame.close();
			this.stage.removeChild(this.newGame);
			this.newGame = undefined;
		}
		if(this.home)
		{
			this.home.close();
			this.stage.removeChild(this.home);
			this.home = undefined;
		}
	}
	
	App.prototype.update = function(event)
	{
		if(this.home) this.home.update();
		if(this.newGame) this.newGame.update();
		if(this.boardGame) this.boardGame.update();
		
		
		Tween.runTweens();

		jeuEurope.appParam.renderer.render(this.stage);

		requestAnimationFrame(this.update.bind(this));
	}

	App.prototype.onClose = function(e)
	{
	    var msg = getText("common","leaveGame");

	    (e || window.event).returnValue = msg; //Gecko + IE
	    return msg; //Gecko + Webkit, Safari, Chrome etc.
	}

	//quand le doc est prêt
	$(document).ready(function()
	{
		//quand la page est chargée
		$(window).load(function()
		{
			jeuEurope.current = new jeuEurope.App();

			window.addEventListener("beforeunload",jeuEurope.current.onClose);

			//console.log(PIXI);
			//console.log(jeuEurope);
		});
	});

}(jeuEurope));

