var jeuEurope = jeuEurope || {};

(function(jeuEurope){

	jeuEurope.OuvWindow = OuvWindow;

	//héritage
	OuvWindow.prototype = Object.create(Container.prototype);

	function OuvWindow(defiData,callbackEnd)
	{
		//constructeur parent
		Container.call(this);

		this.interactive = true;

		//propriétés
		this.greyBackground = undefined;
		this.callbackEnd = callbackEnd;
		this.defiData = defiData;
		this.chronoStarted = false;
		this.chronoCount = jeuEurope.Datas.chronoDuration * 60;
		this.chronoEnded = false;
		this.countFrame = 0;
		this.playerUi = [];

		//construction
		//fenetres
		this.greyBackground = new Graphics();
		this.greyBackground.beginFill(0x000000,0.77);
		this.greyBackground.drawRect(0,0,jeuEurope.appParam.stageWidth,jeuEurope.appParam.stageHeight);
		this.greyBackground.endFill();
		this.addChild(this.greyBackground);

		this.windowOuv = new Sprite(getTexture("questWindow","window"+defiData.type));
		this.windowOuv.anchor.set(0.5,0.5);
		this.windowOuv.position.set(jeuEurope.appParam.stageWidth / 2,jeuEurope.appParam.stageHeight / 2);
		this.addChild(this.windowOuv);

		//----- window content
		this.titre = new Text(
			defiData.titre,
			{
				font:"24px robotor",
				fill:0x183f87,
				align:"left",
				wordWrap:true,
				wordWrapWidth:480
			});
		this.titre.position.set(-136,-305);
		this.windowOuv.addChild(this.titre);

		this.intro = new Text(
			defiData.intro,
			{
				font:"18px robotor",
				fill:0x183f87,
				align:"left",
				wordWrap:true,
				wordWrapWidth:480
			});
		this.intro.position.set(-136,this.titre.y + this.titre.height + 5);
		this.windowOuv.addChild(this.intro);

		this.icone = new Sprite(getTexture("questWindow","icone"));
		this.icone.anchor.set(0.5,0.5);
		this.icone.position.set(-280,0);
		this.windowOuv.addChild(this.icone);

		this.question = new Text(
			defiData.quest,
			{
				font:"22px robotor",
				fill:0x183f87,
				align:"left",
				wordWrap:true,
				wordWrapWidth:550
			});
		this.question.position.set(-215,0);
		this.question.anchor.set(0,0.5);
		this.windowOuv.addChild(this.question);

		//sous sections
		//answering
		this.answerSection = new Container();
		this.windowOuv.addChild(this.answerSection);

		this.chrono = new Sprite(getTexture("questWindow","chrono"));
		this.chrono.anchor.set(0.5,0.5);
		this.chrono.position.set(0,
			this.windowOuv.height / 2 - 125);
		this.answerSection.addChild(this.chrono);

		this.textChrono = new Text(
			this.makeChronoText(),
			{
				font:"32px robotor",
				fill:0xffffff,
				align:"center",
				stroke:0x000000,
				strokeThickness:3
			});
		this.textChrono.anchor.set(0.5,0.5);
		this.textChrono.position.set(0,10);
		this.chrono.addChild(this.textChrono);

		//finishing
		this.selectSection = new Container();
		this.selectSection.visible = false;
		this.windowOuv.addChild(this.selectSection);

		this.textSelect = new Text(
			getText("ouvWindow","teamAnswer"),
			{
				font:"26px robotor",
				fill:0x183f87,
				align:"center",
				wordWrap:true,
				wordWrapWidth:550
			});
		this.textSelect.y = this.windowOuv.height / 2 - 225;
		this.textSelect.anchor.set(0.5,0.5);
		this.selectSection.addChild(this.textSelect);

		//------- Explication reponse

		this.windowExpl = new Sprite(getTexture("questWindow","windowExpl"));
		this.windowExpl.anchor.set(0.5,0.5);
		this.windowExpl.position.set(1040,540);
		this.windowExpl.visible = false;
		this.addChild(this.windowExpl);

		this.titreExpl = new Text(
			getText("questWindow","titreExpl"),
			{
				font:"24px robotor",
				fill:0x183f87,
				align:"center"
			});
		this.titreExpl.anchor.set(0.5,0.5);
		this.titreExpl.position.set(0,-110);

		this.windowExpl.addChild(this.titreExpl);

		this.explText = new Text(
			defiData.expl,
			{
				font:"18px robotor",
				fill:0x183f87,
				align:"center",
				wordWrap: true,
				wordWrapWidth:400
			});
		this.explText.anchor.set(0.5,0.5);
		this.windowExpl.addChild(this.explText);

		//Buttons

		this.btnValid = new jeuEurope.Button(
			getTexture("defiWindow","btnValidUp"),
			getTexture("defiWindow","btnValidDown"),
			getTexture("defiWindow","btnValidHover"),
			this.onPressValid.bind(this));
		this.btnValid.anchor.set(0.5,0.5);
		this.btnValid.position.set(-115, 215);
		this.btnValid.visible = false;
		this.windowOuv.addChild(this.btnValid);

		this.textBtnValid = new Text(
			getText("ouvWindow","btnValid"),
			{
				font:"16px robotor",
				fill:0xffffff,
				align:"center",
				stroke:0x409e01, 
				strokeThickness:3
			});
		this.textBtnValid.anchor.set(0.5,0.5);
		this.btnValid.addChild(this.textBtnValid);

		this.btnInvalid = new jeuEurope.Button(
			getTexture("defiWindow","btnInvalidUp"),
			getTexture("defiWindow","btnInvalidDown"),
			getTexture("defiWindow","btnInvalidHover"),
			this.onPressInvalid.bind(this));
		this.btnInvalid.anchor.set(0.5,0.5);
		this.btnInvalid.position.set(115, 215);
		this.btnInvalid.visible = false;
		this.windowOuv.addChild(this.btnInvalid);

		this.textBtnInvalid = new Text(
			getText("ouvWindow","btnInvalid"),
			{
				font:"28px robotor",
				fill:0xffffff,
				align:"center",
				stroke:0xE80000, 
				strokeThickness:3
			});
		this.textBtnInvalid.anchor.set(0.5,0.5);
		this.btnInvalid.addChild(this.textBtnInvalid);


		this.btnFinish = new jeuEurope.Button(
			getTexture("defiWindow","btnCloseUp"),
			getTexture("defiWindow","btnCloseDown"),
			getTexture("defiWindow","btnCloseHover"),
			this.onPressFinish.bind(this));
		this.btnFinish.anchor.set(0.5,0.5);
		this.btnFinish.position.set(115, 215);
		this.windowOuv.addChild(this.btnFinish);
		this.btnFinish.visible = false;

		this.btnStart = new jeuEurope.Button(
			getTexture("defiWindow","btnPlayUp"),
			getTexture("defiWindow","btnPlayDown"),
			getTexture("defiWindow","btnPlayHover"),
			this.onPressStart.bind(this));
		this.btnStart.anchor.set(0.5,0.5);
		this.btnStart.position.set(-115, 215);
		this.windowOuv.addChild(this.btnStart);

		
		this.btnPause = new jeuEurope.Button(
			getTexture("defiWindow","btnPauseUp"),
			getTexture("defiWindow","btnPauseDown"),
			getTexture("defiWindow","btnPauseHover"),
			this.onPressPause.bind(this));
		this.btnPause.anchor.set(0.5,0.5);
		this.btnPause.position.set(-115, 215);
		this.windowOuv.addChild(this.btnPause);
		this.btnPause.visible = false;		
	}	

	OuvWindow.prototype.onPressValid = function(e)
	{	
		createjs.Sound.play("bouton");

		this.callbackEnd({
				answer:true,
				effect:this.defiData.caseEffect,
				data:this.defiData
			});
	}

	OuvWindow.prototype.onPressInvalid = function(e)
	{
		createjs.Sound.play("bouton");

		this.callbackEnd({
				answer:false,
				effect:this.defiData.caseEffect,
				data:this.defiData
			});
	}

	OuvWindow.prototype.onPressFinish = function(e)
	{
		createjs.Sound.play("bouton");
		this.onEndChrono();
	}

	OuvWindow.prototype.onPressStart = function(e)
	{
		createjs.Sound.play("bouton");
		this.btnStart.visible = false;
		this.btnPause.visible = true;
		this.btnFinish.visible = true;
		this.chronoStarted = true;
	}

	OuvWindow.prototype.onPressPause = function(e)
	{
		createjs.Sound.play("bouton");
		this.btnStart.visible = true;
		this.btnPause.visible = false;
		this.chronoStarted = false;
	}

	OuvWindow.prototype.onEndChrono = function()
	{
		createjs.Sound.play("gong");

		if(this.defiData.expl != "")
		{
			var tweenWindow = new Tween(this.windowOuv,"x",420,60,true);
			tweenWindow.easing = Tween.inOutCubic;
			tweenWindow.setOnComplete(this.showRepExplained.bind(this));
		}

		this.chronoEnded = true;
		this.btnValid.visible = true;
		this.btnInvalid.visible = true;
		this.btnFinish.visible = false;
		this.answerSection.visible = false;
		this.selectSection.visible = true;
		this.btnPause.visible = false;
		this.btnStart.visible = false;
	}

	OuvWindow.prototype.showRepExplained = function()
	{
		this.windowExpl.visible = true;
	}	

	OuvWindow.prototype.update = function()
	{
		if(this.chronoStarted && !this.chronoEnded)
		{
			this.countFrame++;
			if(this.countFrame > 60)
			{
				this.countFrame = 0;
				this.chronoCount--;

				this.textChrono.text = this.makeChronoText();

				if(this.chronoCount == 0)
					this.onEndChrono();
			}
		}
	}

	OuvWindow.prototype.makeChronoText = function()
	{
		var sec = this.chronoCount % 60;
		var min = (this.chronoCount - sec) / 60;

		var strMin = (min < 10 ? "0"+min : min);
		var strSec = (sec < 10 ? "0"+sec : sec);

		return (strMin+":"+strSec);
	}

}(jeuEurope));