var jeuEurope = jeuEurope || {};

(function(jeuEurope){

	jeuEurope.DefiWindow = DefiWindow;

	//héritage
	DefiWindow.prototype = Object.create(Container.prototype);

	function DefiWindow(defiData,callbackEnd)
	{
		//constructeur parent
		Container.call(this);

		this.interactive = true;

		//propriétés
		this.greyBackground = undefined;
		this.callbackEnd = callbackEnd;
		this.defiData = defiData;
		this.chronoStarted = false;
		this.chronoCount = jeuEurope.Datas.chronoDuration * 60;
		this.chronoEnded = false;
		this.countFrame = 0;
		this.playerUi = [];

		//construction
		//fenetres
		this.greyBackground = new Graphics();
		this.greyBackground.beginFill(0x000000,0.77);
		this.greyBackground.drawRect(0,0,jeuEurope.appParam.stageWidth,jeuEurope.appParam.stageHeight);
		this.greyBackground.endFill();
		this.addChild(this.greyBackground);

		this.windowDefi = new Sprite(getTexture("defiWindow","verso"));
		this.windowDefi.anchor.set(0.5,0.5);
		this.windowDefi.position.set(jeuEurope.appParam.stageWidth / 2,jeuEurope.appParam.stageHeight / 2);
		this.addChild(this.windowDefi);

		//----- window content
		this.titre = new Text(
			defiData.titre,
			{
				font:"28px robotor",
				fill:0xffffff,
				align:"left",
				stroke:0x000000,
				strokeThickness:3
			});
		this.titre.position.set(0,-this.windowDefi.height / 2 + 30);
		this.titre.anchor.set(0.5,0.5);
		this.windowDefi.addChild(this.titre);

		this.question = new Text(
			defiData.quest,
			{
				font:"18px robotor",
				fill:0xffffff,
				align:"center",
				wordWrap:true,
				wordWrapWidth:630
			});
		this.question.position.set(0,-15);
		this.question.anchor.set(0.5,0);
		this.windowDefi.addChild(this.question);

		//sous sections
		//answering
		this.answerSection = new Container();
		this.windowDefi.addChild(this.answerSection);

		this.chrono = new Sprite(getTexture("questWindow","chrono"));
		this.chrono.anchor.set(0.5,0.5);
		this.chrono.position.set(0,
			this.windowDefi.height / 2 - 125);
		this.answerSection.addChild(this.chrono);

		this.textChrono = new Text(
			this.makeChronoText(),
			{
				font:"26px robotor",
				fill:0xffffff,
				align:"center",
				stroke:0x000000,
				strokeThickness:3
			});
		this.textChrono.anchor.set(0.5,0.5);
		this.textChrono.position.set(0,10);
		this.chrono.addChild(this.textChrono);

		//selecting
		this.selectSection = new Container();
		this.selectSection.visible = false;
		this.selectSection.position.y = 25;
		this.windowDefi.addChild(this.selectSection);

		var listPlayers = jeuEurope.current.boardGame.listPlayers;
		var spaceBetweenElement = 100;
		var totalWidth = (spaceBetweenElement * (listPlayers.length-1));
		var start = -totalWidth/2;

		for (var i = 0; i < listPlayers.length; i++) {
			var player = listPlayers[i];

			var uiElement = this.createPlayerUi(player);
			this.selectSection.addChild(uiElement);

			uiElement.x = start + spaceBetweenElement * i;
			uiElement.y = this.windowDefi.height / 2 - 125;

			this.playerUi.push(uiElement);
		};

		this.textSelect = new Text(
			getText("defiWindow","selectTeam"),
			{
				font:"22px robotor",
				fill:0xffffff,
				align:"center",
				wordWrap:true,
				wordWrapWidth:550
			});
		this.textSelect.y = this.windowDefi.height / 2 - 225;
		this.textSelect.anchor.set(0.5,0.5);
		this.selectSection.addChild(this.textSelect);


		//Buttons

		this.btnValid = new jeuEurope.Button(
			getTexture("questWindow","btnValidUp"),
			getTexture("questWindow","btnValidDown"),
			getTexture("questWindow","btnValidHover"),
			this.onPressValid.bind(this));
		this.btnValid.anchor.set(0.5,0.5);
		this.btnValid.position.set(0, this.windowDefi.height / 2);
		this.btnValid.visible = false;
		this.windowDefi.addChild(this.btnValid);

		this.textBtnValid = new Text(
			getText("defiWindow","btnValid"),
			{
				font:"16px robotor",
				fill:0xffffff,
				align:"center",
				stroke:0x409e01, 
				strokeThickness:3
			});
		this.textBtnValid.anchor.set(0.5,0.5);
		this.btnValid.addChild(this.textBtnValid);


		this.btnFinish = new jeuEurope.Button(
			getTexture("defiWindow","btnCloseUp"),
			getTexture("defiWindow","btnCloseDown"),
			getTexture("defiWindow","btnCloseHover"),
			this.onPressFinish.bind(this));
		this.btnFinish.anchor.set(0.5,0.5);
		this.btnFinish.position.set(115, 215);
		this.windowDefi.addChild(this.btnFinish);
		this.btnFinish.visible = false;

		this.btnStart = new jeuEurope.Button(
			getTexture("defiWindow","btnPlayUp"),
			getTexture("defiWindow","btnPlayDown"),
			getTexture("defiWindow","btnPlayHover"),
			this.onPressStart.bind(this));
		this.btnStart.anchor.set(0.5,0.5);
		this.btnStart.position.set(-115, 215);
		this.windowDefi.addChild(this.btnStart);

		
		this.btnPause = new jeuEurope.Button(
			getTexture("defiWindow","btnPauseUp"),
			getTexture("defiWindow","btnPauseDown"),
			getTexture("defiWindow","btnPauseHover"),
			this.onPressPause.bind(this));
		this.btnPause.anchor.set(0.5,0.5);
		this.btnPause.position.set(-115, 215);
		this.windowDefi.addChild(this.btnPause);
		this.btnPause.visible = false;		

		createjs.Sound.play("succes1");

		this.escape = new Keyboard(27);
		this.escape.press = this.onPressValid.bind(this);
		this.space = new Keyboard(32);
		this.space.press = this.onPressValid.bind(this);
	}	

	DefiWindow.prototype.createPlayerUi = function(player)
	{
		var contain = new Container();
		contain.selected = false;
		contain.interactive = true;
		contain.player = player;

		contain.team = new Sprite(getTexture("gameUi","team"+player.id));
		contain.team.anchor.set(0.5,0.5);
		contain.addChild(contain.team);

		contain.haloSelect = new Sprite(getTexture("gameUi","haloSelect"));
		contain.haloSelect.anchor.set(0.5,0.5);
		contain.haloSelect.visible = false;

		contain.team.addChild(contain.haloSelect);
		
		contain.onPressed = function()
		{
			this.haloSelect.visible = !this.haloSelect.visible;
			this.selected = !this.selected;
		}

		contain.on("mouseup",contain.onPressed.bind(contain));

		return contain;
	}

	DefiWindow.prototype.onPressValid = function(e)
	{
		if(!this.btnValid.visible)
			return;

		createjs.Sound.play("bouton");
		
		var validatedPlayers = [];

		for (var i = 0; i < this.playerUi.length; i++) {
			if(this.playerUi[i].selected)
				validatedPlayers.push(this.playerUi[i].player.id);
		};

		this.escape.remove();
		this.space.remove();

		this.callbackEnd({
				validPlayers:validatedPlayers,
				effect:this.defiData.caseEffect,
				data:this.defiData
			});
	}

	DefiWindow.prototype.onPressFinish = function(e)
	{
		createjs.Sound.play("bouton");
		this.onEndChrono();
	}

	DefiWindow.prototype.onPressStart = function(e)
	{
		createjs.Sound.play("bouton");
		this.btnStart.visible = false;
		this.btnPause.visible = true;
		this.btnFinish.visible = true;
		this.chronoStarted = true;
	}

	DefiWindow.prototype.onPressPause = function(e)
	{
		createjs.Sound.play("bouton");
		this.btnStart.visible = true;
		this.btnPause.visible = false;
		this.chronoStarted = false;
	}

	DefiWindow.prototype.onEndChrono = function()
	{
		this.chronoEnded = true;
		this.btnValid.visible = true;
		this.btnFinish.visible = false;
		this.btnStart.visible = false;
		this.answerSection.visible = false;
		this.selectSection.visible = true;
		this.btnPause.visible = false;

		createjs.Sound.play("gong");
	}

	DefiWindow.prototype.update = function()
	{
		if(this.chronoStarted && !this.chronoEnded)
		{
			this.countFrame++;
			if(this.countFrame > 60)
			{
				this.countFrame = 0;
				this.chronoCount--;

				this.textChrono.text = this.makeChronoText();

				if(this.chronoCount == 0)
					this.onEndChrono();
			}
		}
	}

	DefiWindow.prototype.makeChronoText = function()
	{
		var sec = this.chronoCount % 60;
		var min = (this.chronoCount - sec) / 60;

		var strMin = (min < 10 ? "0"+min : min);
		var strSec = (sec < 10 ? "0"+sec : sec);

		return (strMin+":"+strSec);
	}

}(jeuEurope));