var jeuEurope = jeuEurope || {};

(function(jeuEurope){

	jeuEurope.NewGame = NewGame;

	//héritage
	NewGame.prototype = Object.create(Container.prototype);

	function NewGame()
	{
		//constructeur parent
		Container.call(this);

		this.titre1 = undefined;
		this.titre2 = undefined;
		this.titre3 = undefined;

		this.yellowLine = undefined;

		this.btnInfo = undefined;
		this.btnSettings = undefined;
		this.btnPlay = undefined;

		this.textBtnPlay = undefined;

		this.boardPicto = undefined;

		this.settingsWindow = undefined;

		this.teams = [];
		//------- Titre -------

		this.titre1 = new Text(
			getText("newGame","titre1"),
			{
				font:"101px monstro",
				fill:0xf1cb12,
				align:"left"
			});

		this.titre1.position.set(30, 5);

		this.titre2 = new Text(
			getText("newGame","titre2"),
			{
				font:"59px monstro",
				fill:0xffffff,
				align:"left"
			});

		this.titre2.position.set(30, 95);

		this.titre3 = new Text(
			getText("newGame","titre3"),
			{
				font:"30px robotor",
				fill:0xf1cb12,
				align:"left"
			});

		this.titre3.position.set(30, 150);

		this.addChild(this.titre1);
		this.addChild(this.titre2);
		this.addChild(this.titre3);

		//------- Visual ------
		this.yellowLine = new Sprite(getTexture("newGame","yellowLine"));

		this.yellowLine.position.set(
			this.titre3.x + this.titre3.width + 10, 
			this.titre3.y + this.titre3.height / 2);

		this.yellowLine.scale.x = 2;
		this.addChild(this.yellowLine);

		this.boardPicto = new Sprite(getTexture("newGame","boardPicto"));

		this.boardPicto.anchor.set(0.5,0.5);
		this.boardPicto.position.set(1175,450);
		this.addChild(this.boardPicto);

		//------- Buttons -------

		//play
		this.btnPlay = new jeuEurope.Button(
			getTexture("newGame","btnPlayUp"),
			getTexture("newGame","btnPlayDown"),
			getTexture("newGame","btnPlayHover"),
			this.onPressPlay.bind(this));

		this.btnPlay.anchor.set(0.5,0.5);
		this.btnPlay.position.set(1180,550);
		this.addChild(this.btnPlay);

		this.textBtnPlay = new Text(
			getText("newGame","btnPlay"),
			{
				font:"36px robotor",
				fill:0xffffff,
				stroke:0x409e01, 
				strokeThickness:3, 
				align:"center"
			});

		this.textBtnPlay.y = -5;
		this.textBtnPlay.anchor.set(0.5,0.5);
		this.btnPlay.addChild(this.textBtnPlay);

		//--------- Teams ---------

		var teamPos = [
			{x:35,y:285},
			{x:35,y:485},
			{x:35,y:685},
			{x:575,y:285},
			{x:575,y:485},
			{x:575,y:685}
		];

		for (var i = 0; i < 6; i++) {
			var team = this.createTeam(i+1, teamPos[i]);

			this.teams.push(team);
			this.addChild(team);
		};

		

	}

	NewGame.prototype.createTeam = function(index, pos)
	{
		var contain = new Container();
		contain.position.set(pos.x,pos.y);

		var logo = new Sprite(getTexture("newGame","team"+index));
		logo.anchor.set(0,0.5);

		var backgroundTeamName = new Sprite(getTexture("newGame","input"));
		backgroundTeamName.anchor.set(0,0.5);
		backgroundTeamName.position.set(160,-32);

		var backgroundTeamSchool = new Sprite(getTexture("newGame","input"));
		backgroundTeamSchool.anchor.set(0,0.5);
		backgroundTeamSchool.position.set(160,32);

		contain.addChild(logo);
		contain.addChild(backgroundTeamName);
		contain.addChild(backgroundTeamSchool);

		var inputName = new PIXI.Input({
		    maxlength: 10,
		    placeholder: getText("newGame","placeholderTeam")+index,
		    placeholderColor: "#b7b7b7",
		    selectionColor: "rgba(179, 212, 253, 0.8)",
		    value: "",
		    type: "text",
		    width: 300,
		    height: 56,
		    padding: 5,
		    borderColor: "#000",
		    borderWidth: 0,
		    borderRadius: 0,
		    backgroundImage: null,
		    backgroundColor: "rgba(0,0,0,0)",
		    backgroundGradient: null,
		    boxShadow: null,
		    innerShadow: null,
		    valign: "middle",
		    align: "center",
		    outline: 0,
		    text: {
		        font: "30px monstro",
		        fill: "#0e3d8a",
		        align: "left"
		    }
		});

		inputName.position.set(5,-33);
		backgroundTeamName.addChild(inputName);

		var inputSchool = new PIXI.Input({
		    maxlength: null,
		    placeholder: getText("newGame","placeholderSchool"),
		    placeholderColor: "#b7b7b7",
		    selectionColor: "rgba(179, 212, 253, 0.8)",
		    value: "",
		    type: "text",
		    width: 300,
		    height: 56,
		    padding: 5,
		    borderColor: "#000",
		    borderWidth: 0,
		    borderRadius: 0,
		    backgroundImage: null,
		    backgroundColor: "rgba(0,0,0,0)",
		    backgroundGradient: null,
		    boxShadow: null,
		    innerShadow: null,
		    valign: "middle",
		    align: "center",
		    outline: 0,
		    text: {
		        font: "25px robotor",
		        fill: "#0e3d8a",
		        align: "left"
		    }
		});
		
		inputSchool.position.set(5,-33);
		backgroundTeamSchool.addChild(inputSchool);

		contain.teamName = inputName;
		contain.teamSchool = inputSchool;

		return contain;
	}

	NewGame.prototype.onPressPlay = function()
	{
		if(this.btnPlay.alpha != 1)
			return;

		createjs.Sound.play("bouton");
		
		var gameTeam = [];
		for (var i = 0; i < this.teams.length; i++) {
			if(this.teams[i].teamName.value != "")
			{
				gameTeam.push(
					{
						id:i+1,
						name:this.teams[i].teamName.value,
						school:this.teams[i].teamSchool.value,
					});
			}
		};

		gameTeam = shuffleArray(gameTeam);

		jeuEurope.current.openBoardGame(gameTeam);
	}

	NewGame.prototype.update = function()
	{
		var countFilled = 0;
		for (var i = 0; i < this.teams.length; i++) {
			var team = this.teams[i];

			if(team.teamName.value != "")
			{
				countFilled++;
			}
		};

		this.btnPlay.alpha = (countFilled > 1 ? 1 : 0.5);

		var ts = this.teams[0].teamSchool.value;
		if(ts != "" && this.teams[0].teamSchool.focused)
		{
			for (var i = 1; i < this.teams.length; i++) {
				var t = this.teams[i]
				if((t.teamSchool.value == "" 
					|| ts.indexOf(t.teamSchool.value) != -1
					|| t.teamSchool.value.indexOf(ts) != -1) 
					&& ts != t.teamSchool.value)
				{
					t.teamSchool.value = ts;
					t.teamSchool.colorNormal();
				}
			}
		}
	}

	NewGame.prototype.close = function()
	{

	}

}(jeuEurope));