var jeuEurope = jeuEurope || {};

(function(jeuEurope){

	jeuEurope.Button = Button;

	//héritage
	Button.prototype = Object.create(Sprite.prototype);

	function Button(texBase,texDown,texHover,onClick)
	{
		//constructeur parent
		Sprite.call(this,texBase);

		//propriétés
		this.onClick = onClick;

		this.texBase = texBase;
		this.texDown = texDown;
		this.texHover = texHover;

		this.interactive = true;
		this.buttonMode = true;

	    this
	        // set the mousedown and touchstart callback...
	        .on('mousedown', this.onButtonDown)
	        .on('touchstart', this.onButtonDown)

	        // set the mouseup and touchend callback...
	        .on('mouseup', this.onButtonUp)
	        .on('touchend', this.onButtonUp)
	        //outside
	        .on('mouseupoutside', this.onButtonUpOutside)
	        .on('touchendoutside', this.onButtonUpOutside)

	        // set the mouseover callback...
	        .on('mouseover', this.onButtonOver)

	        // set the mouseout callback...
	        .on('mouseout', this.onButtonOut);
	}

	Button.prototype.onButtonDown = function (e)
	{
	    this.texture = this.texDown;

	    this.isdown = true;
	}

	Button.prototype.onButtonUp = function (e)
	{
	    if (this.isOver)
	    {
	    	if(this.isdown && this.onClick) 
				this.onClick(e);

	        this.texture = this.texHover;
	    }
	    else
	    {
	    	if(this.isdown && this.onClick) 
				this.onClick(e);

	        this.texture = this.texBase;
	    }

	    this.isdown = false;
	}

	Button.prototype.onButtonOver = function (e)
	{
	    if (!this.isdown)
	    {
	        this.texture = this.texHover;
	    }

	    this.isOver = true;
	}

	Button.prototype.onButtonOut = function (e)
	{
	    if (!this.isdown)
	    {
	        this.texture = this.texBase;
	    }

	    this.isOver = false;
	}

	Button.prototype.onButtonUpOutside = function(e)
	{
		this.texture = this.texBase;

		this.isOver = false;
		this.isdown = false;
	}


}(jeuEurope));